*                                                                                  ;
 *    Reading in the 1992 PSID data                                                 ;
 *                                                                                  ;
 *            Karen Dynan 8/26/06                                                   ;
 *                                                                                  ;
 *    We read it all in and then output select variables to a flat                  ;
 *    file to be picked up by STATA.                                                ;
 *                                                                                  ;
 
libname psid 'F:\PSID' ;
filename rawdat 'F:\PSID\raw\fam92.raw' ;
 
 data one;
 
   infile 'F:\PSID\92FAM.DAT'  lrecl=2347 missover;
   INPUT
   V20301 1-3             V20302 4-8             V20303 9-10
   V20304 11-13           V20305 14-18           V20306 19
   V20307 20              V20308 21              V20309 22
   V20310 23              V20311 24              V20312 25
   V20313 26              V20314 27              V20315 28
   V20316 29              V20317 30-33           V20318 34-36
   V20319 37-38           V20320 39              V20321 40-41
   V20322 42              V20323 43              V20324 44-49
   V20325 50              V20326 51-56           V20327 57
   V20328 58-62           V20329 63              V20330 64-68
   V20331 69              V20332 70-73           V20333 74-78
   V20334 79              V20335 80-83           V20336 84
   V20337 85-88           V20338 89-92           V20339 93
   V20340 94-97           V20341 98              V20342 99-102
   V20343 103             V20344 104-107         V20345 108-111
   V20346 112             V20347 113-116         V20348 117
   V20349 118-121         V20350 122             V20351 123-126
   V20352 127             V20353 128-131         V20354 132
   V20355 133             V20356 134             V20357 135
   V20358 136             V20359 137             V20360 138
   V20361 139             V20362 140             V20363 141
   V20364 142             V20365 143             V20366 144
   V20367 145             V20368 146-149         V20369 150
   V20370 151-154         V20371 155             V20372 156-159
   V20373 160             V20374 161-164         V20375 165-168
   V20376 169             V20377 170-173         V20378 174
   V20379 175-178         V20380 179             V20381 180-183
   V20382 184             V20383 185-188         V20384 189
   V20385 190             V20386 191             V20387 192
   V20388 193             V20389 194             V20390 195
   V20391 196             V20392 197             V20393 198
   V20394 199             V20395 200             V20396 201
   V20397 202             V20398 203-204         V20399 205
   V20400 206-209         V20401 210             V20402 211-214
   V20403 215             V20404 216             V20405 217-219
   V20406 220             V20407 221-225         V20408 226
   V20409 227-230         V20410 231             V20411 232-235
   V20412 236             V20413 237-238         V20414 239
   V20415 240             V20416 241             V20417 242
   V20418 243             V20419 244             V20420 245
   V20421 246             V20422 247             V20423 248
   V20424 249             V20425 250             V20426 251
   V20427 252-256         V20428 257-261         V20429 262-267
   V20430 268             V20431 269-273         V20432 274-279
   V20433 280-284         V20434 285-289         V20435 290
   V20436 291-296         V20437 297             V20438 298-303
   V20439 304-309         V20440 310-314         V20441 315-319
   V20442 320-325         V20443 326-327         V20444 328-333
   V20445 334-335         V20446 336-341         V20447 342-343
   V20448 344-349         V20449 350-355         V20450 356
   V20451 357-363         V20452 364-368         V20453 369-373
   V20454 374-378         V20455 379             V20456 380-381
   V20457 382             V20458 383             V20459 384-388
   V20460 389             V20461 390-391         V20462 392-396
   V20463 397-401         V20464 402-403         V20465 404-408
   V20466 409             V20467 410-411         V20468 412-416
   V20469 417-418         V20470 419-423         V20471 424
   V20472 425-429         V20473 430-434         V20474 435-436
   V20475 437-441         V20476 442-443         V20477 444-448
   V20478 449-450         V20479 451-455         V20480 456-460
   V20481 461             V20482 462-463         V20483 464-468
   V20484 469-473         V20485 474-475         V20486 476-480
   V20487 481             V20488 482-483         V20489 484-488
   V20490 489-490         V20491 491-495         V20492 496-500
   V20493 501-505         V20494 506-507         V20495 508-512
   V20496 513-514         V20497 515-519         V20498 520-521
   V20499 522-526         V20500 527             V20501 528-532
   V20502 533             V20503 534             V20504 535
   V20505 536             V20506 537             V20507 538
   V20508 539             V20509 540             V20510 541
   V20511 542             V20512 543             V20513 544
   V20514 545             V20515 546             V20516 547
   V20517 548             V20518 549             V20519 550
   V20520 551             V20521 552             V20522 553
   V20523 554             V20524 555             V20525 556
   V20526 557             V20527 558             V20528 559
   V20529 560             V20530 561             V20531 562
   V20532 563             V20533 564             V20534 565
   V20535 566             V20536 567             V20537 568
   V20538 569             V20539 570             V20540 571
   V20541 572             V20542 573             V20543 574
   V20544 575             V20545 576             V20546 577
   V20547 578             V20548 579             V20549 580
   V20550 581             V20551 582             V20552 583
   V20553 584             V20554 585             V20555 586
   V20556 587             V20557 588             V20558 589
   V20559 590             V20560 591             V20561 592
   V20562 593             V20563 594             V20564 595
   V20565 596             V20566 597             V20567 598
   V20568 599             V20569 600             V20570 601
   V20571 602             V20572 603             V20573 604
   V20574 605             V20575 606-607         V20576 608-609
   V20577 610-615         V20578 616-617         V20579 618
   V20580 619-620         V20581 621-622         V20582 623-628
   V20583 629-630         V20584 631             V20585 632-633
   V20586 634-635         V20587 636-641         V20588 642-643
   V20589 644             V20590 645-646         V20591 647-648
   V20592 649-654         V20593 655-656         V20594 657
   V20595 658-659         V20596 660-661         V20597 662-667
   V20598 668-669         V20599 670             V20600 671-674
   V20601 675-680         V20602 681             V20603 682-686
   V20604 687             V20605 688-692         V20606 693-697
   V20607 698-702         V20608 703-707         V20609 708-712
   V20610 713-717         V20611 718-722         V20612 723-727
   V20613 728-732         V20614 733-737         V20615 738-742
   V20616 743-747         V20617 748-752         V20618 753
   V20619 754             V20620 755             V20621 756-759
   V20622 760-763         V20623 764-767         V20624 768-771
   V20625 772-775         V20626 776-779         V20627 780-783
   V20628 784-787         V20629 788-791         V20630 792-795
   V20631 796-799         V20632 800-803         V20633 804-807
   V20634 808-811         V20635 812-815         V20636 816-819
   V20637 820-823         V20638 824-827         V20639 828-831
   V20640 832-835         V20641 836-839         V20642 840-843
   V20643 844-848         V20644 849-853         V20645 854-857
   V20646 858-861         V20647 862-864         V20648 865-868
   V20649 869-871         V20650 872-873         V20651 874-875
   V20652 876             V20653 877-878         V20654 879-880
   V20655 881-882         V20656 883-884         V20657 885
   V20658 886             V20659 887             V20660 888
   V20661 889             V20662 890             V20663 891
   V20664 892             V20665 893             V20666 894
   V20667 895             V20668 896-897         V20669 898-899
   V20670 900-901         V20671 902             V20672 903
   V20673 904             V20674 905-906         V20675 907
   V20676 908             V20677 909             V20678 910
   V20679 911             V20680 912             V20681 913
   V20682 914             V20683 915             V20684 916
   V20685 917             V20686 918             V20687 919
   V20688 920-921         V20689 922             V20690 923
   V20691 924             V20692 925             V20693 926
   V20694 927-928         V20695 929             V20696 930
   V20697 931             V20698 932             V20699 933
   V20700 934             V20701 935-937         V20702 938-940
   V20703 941             V20704 942-945         V20705 946
   V20706 947-950         V20707 951-954         V20708 955-958
   V20709 959             V20710 960-963         V20711 964
   V20712 965             V20713 966             V20714 967
   V20715 968             V20716 969             V20717 970
   V20718 971             V20719 972             V20720 973-975
   V20721 976-977         V20722 978-979         V20723 980
   V20724 981-982         V20725 983-984         V20726 985
   V20727 986-987         V20728 988             V20729 989-990
   V20730 991-992         V20731 993-994         V20732 995-996
   V20733 997             V20734 998-999         V20735 1000
   V20736 1001-1003       V20737 1004-1007       V20738 1008-1009
   V20739 1010            V20740 1011            V20741 1012
   V20742 1013            V20743 1014            V20744 1015
   V20745 1016            V20746 1017            V20747 1018
   V20748 1019            V20749 1020            V20750 1021
   V20751 1022            V20752 1023-1024       V20753 1025-1026
   V20754 1027            V20755 1028            V20756 1029
   V20757 1030            V20758 1031            V20759 1032
   V20760 1033            V20761 1034            V20762 1035
   V20763 1036            V20764 1037            V20765 1038
   V20766 1039            V20767 1040            V20768 1041
   V20769 1042-1044       V20770 1045-1047       V20771 1048-1051
   V20772 1052-1053       V20773 1054            V20774 1055-1056
   V20775 1057            V20776 1058            V20777 1059-1060
   V20778 1061-1062       V20779 1063            V20780 1064-1067
   V20781 1068-1069       V20782 1070            V20783 1071-1072
   V20784 1073            V20785 1074-1075       V20786 1076
   V20787 1077-1078       V20788 1079            V20789 1080-1081
   V20790 1082            V20791 1083-1084       V20792 1085
   V20793 1086-1087       V20794 1088            V20795 1089-1090
   V20796 1091-1092       V20797 1093-1094       V20798 1095
   V20799 1096            V20800 1097            V20801 1098
   V20802 1099-1101       V20803 1102-1104       V20804 1105-1108
   V20805 1109-1110       V20806 1111-1112       V20807 1113-1114
   V20808 1115-1116       V20809 1117            V20810 1118
   V20811 1119            V20812 1120            V20813 1121
   V20814 1122            V20815 1123            V20816 1124
   V20817 1125            V20818 1126            V20819 1127
   V20820 1128            V20821 1129            V20822 1130-1131
   V20823 1132-1133       V20824 1134            V20825 1135-1137
   V20826 1138-1140       V20827 1141-1144       V20828 1145-1146
   V20829 1147-1148       V20830 1149-1150       V20831 1151-1152
   V20832 1153            V20833 1154            V20834 1155
   V20835 1156            V20836 1157            V20837 1158
   V20838 1159            V20839 1160            V20840 1161
   V20841 1162            V20842 1163            V20843 1164
   V20844 1165            V20845 1166-1167       V20846 1168-1169
   V20847 1170            V20848 1171            V20849 1172
   V20850 1173            V20851 1174            V20852 1175
   V20853 1176            V20854 1177            V20855 1178
   V20856 1179-1180       V20857 1181            V20858 1182-1183
   V20859 1184-1185       V20860 1186            V20861 1187-1188
   V20862 1189-1191       V20863 1192-1194       V20864 1195
   V20865 1196            V20866 1197            V20867 1198
   V20868 1199-1200       V20869 1201-1202       V20870 1203
   V20871 1204-1205       V20872 1206-1207       V20873 1208
   V20874 1209-1210       V20875 1211            V20876 1212-1213
   V20877 1214-1215       V20878 1216-1217       V20879 1218-1219
   V20880 1220            V20881 1221-1222       V20882 1223
   V20883 1224-1226       V20884 1227-1230       V20885 1231-1232
   V20886 1233            V20887 1234            V20888 1235
   V20889 1236            V20890 1237            V20891 1238
   V20892 1239            V20893 1240            V20894 1241
   V20895 1242            V20896 1243            V20897 1244
   V20898 1245            V20899 1246-1247       V20900 1248-1249
   V20901 1250            V20902 1251            V20903 1252
   V20904 1253            V20905 1254            V20906 1255
   V20907 1256            V20908 1257            V20909 1258
   V20910 1259            V20911 1260            V20912 1261
   V20913 1262            V20914 1263            V20915 1264
   V20916 1265-1267       V20917 1268-1270       V20918 1271-1274
   V20919 1275-1276       V20920 1277            V20921 1278-1279
   V20922 1280            V20923 1281            V20924 1282-1283
   V20925 1284-1285       V20926 1286            V20927 1287-1290
   V20928 1291-1292       V20929 1293            V20930 1294-1295
   V20931 1296            V20932 1297-1298       V20933 1299
   V20934 1300-1301       V20935 1302            V20936 1303-1304
   V20937 1305            V20938 1306-1307       V20939 1308
   V20940 1309-1310       V20941 1311            V20942 1312-1313
   V20943 1314-1315       V20944 1316-1317       V20945 1318
   V20946 1319            V20947 1320            V20948 1321
   V20949 1322-1324       V20950 1325-1327       V20951 1328-1331
   V20952 1332-1333       V20953 1334-1335       V20954 1336-1337
   V20955 1338-1339       V20956 1340            V20957 1341
   V20958 1342            V20959 1343            V20960 1344
   V20961 1345            V20962 1346            V20963 1347
   V20964 1348            V20965 1349            V20966 1350
   V20967 1351            V20968 1352            V20969 1353-1354
   V20970 1355-1356       V20971 1357            V20972 1358-1360
   V20973 1361-1363       V20974 1364-1367       V20975 1368-1369
   V20976 1370-1371       V20977 1372-1373       V20978 1374-1375
   V20979 1376            V20980 1377            V20981 1378
   V20982 1379            V20983 1380            V20984 1381
   V20985 1382            V20986 1383            V20987 1384
   V20988 1385            V20989 1386            V20990 1387
   V20991 1388            V20992 1389-1390       V20993 1391-1392
   V20994 1393            V20995 1394            V20996 1395-1396
   V20997 1397            V20998 1398            V20999 1399
   V21000 1400            V21001 1401            V21002 1402
   V21003 1403-1405       V21004 1406-1408       V21005 1409
   V21006 1410-1413       V21007 1414            V21008 1415-1418
   V21009 1419-1422       V21010 1423-1426       V21011 1427
   V21012 1428-1431       V21013 1432            V21014 1433
   V21015 1434            V21016 1435            V21017 1436
   V21018 1437            V21019 1438            V21020 1439
   V21021 1440            V21022 1441-1443       V21023 1444-1445
   V21024 1446-1447       V21025 1448            V21026 1449-1450
   V21027 1451-1452       V21028 1453            V21029 1454-1455
   V21030 1456            V21031 1457-1458       V21032 1459-1460
   V21033 1461-1462       V21034 1463-1464       V21035 1465
   V21036 1466-1467       V21037 1468            V21038 1469-1471
   V21039 1472-1475       V21040 1476-1477       V21041 1478
   V21042 1479            V21043 1480            V21044 1481
   V21045 1482            V21046 1483            V21047 1484
   V21048 1485            V21049 1486            V21050 1487
   V21051 1488            V21052 1489            V21053 1490
   V21054 1491-1492       V21055 1493-1494       V21056 1495
   V21057 1496            V21058 1497            V21059 1498
   V21060 1499            V21061 1500            V21062 1501
   V21063 1502            V21064 1503            V21065 1504
   V21066 1505            V21067 1506            V21068 1507
   V21069 1508            V21070 1509            V21071 1510-1512
   V21072 1513-1515       V21073 1516-1519       V21074 1520-1521
   V21075 1522            V21076 1523-1524       V21077 1525
   V21078 1526            V21079 1527-1528       V21080 1529-1530
   V21081 1531            V21082 1532-1535       V21083 1536-1537
   V21084 1538            V21085 1539-1540       V21086 1541
   V21087 1542-1543       V21088 1544            V21089 1545-1546
   V21090 1547            V21091 1548-1549       V21092 1550
   V21093 1551-1552       V21094 1553            V21095 1554-1555
   V21096 1556            V21097 1557-1558       V21098 1559-1560
   V21099 1561-1562       V21100 1563            V21101 1564
   V21102 1565            V21103 1566            V21104 1567-1569
   V21105 1570-1572       V21106 1573-1576       V21107 1577-1578
   V21108 1579-1580       V21109 1581-1582       V21110 1583-1584
   V21111 1585            V21112 1586            V21113 1587
   V21114 1588            V21115 1589            V21116 1590
   V21117 1591            V21118 1592            V21119 1593
   V21120 1594            V21121 1595            V21122 1596
   V21123 1597            V21124 1598-1599       V21125 1600-1601
   V21126 1602            V21127 1603-1605       V21128 1606-1608
   V21129 1609-1612       V21130 1613-1614       V21131 1615-1616
   V21132 1617-1618       V21133 1619-1620       V21134 1621
   V21135 1622            V21136 1623            V21137 1624
   V21138 1625            V21139 1626            V21140 1627
   V21141 1628            V21142 1629            V21143 1630
   V21144 1631            V21145 1632            V21146 1633
   V21147 1634-1635       V21148 1636-1637       V21149 1638
   V21150 1639            V21151 1640            V21152 1641
   V21153 1642            V21154 1643            V21155 1644
   V21156 1645            V21157 1646            V21158 1647-1648
   V21159 1649            V21160 1650-1651       V21161 1652-1653
   V21162 1654            V21163 1655-1656       V21164 1657-1659
   V21165 1660-1662       V21166 1663            V21167 1664
   V21168 1665            V21169 1666            V21170 1667-1668
   V21171 1669-1670       V21172 1671            V21173 1672-1673
   V21174 1674-1675       V21175 1676            V21176 1677-1678
   V21177 1679            V21178 1680-1681       V21179 1682-1683
   V21180 1684-1685       V21181 1686-1687       V21182 1688
   V21183 1689-1690       V21184 1691            V21185 1692-1694
   V21186 1695-1698       V21187 1699-1700       V21188 1701
   V21189 1702            V21190 1703            V21191 1704
   V21192 1705            V21193 1706            V21194 1707
   V21195 1708            V21196 1709            V21197 1710
   V21198 1711            V21199 1712            V21200 1713
   V21201 1714-1715       V21202 1716-1717       V21203 1718
   V21204 1719            V21205 1720            V21206 1721
   V21207 1722            V21208 1723            V21209 1724
   V21210 1725            V21211 1726            V21212 1727
   V21213 1728            V21214 1729            V21215 1730
   V21216 1731            V21217 1732            V21218 1733-1735
   V21219 1736-1738       V21220 1739-1742       V21221 1743-1744
   V21222 1745            V21223 1746-1747       V21224 1748
   V21225 1749            V21226 1750-1751       V21227 1752-1753
   V21228 1754            V21229 1755-1758       V21230 1759-1760
   V21231 1761            V21232 1762-1763       V21233 1764
   V21234 1765-1766       V21235 1767            V21236 1768-1769
   V21237 1770            V21238 1771-1772       V21239 1773
   V21240 1774-1775       V21241 1776            V21242 1777-1778
   V21243 1779            V21244 1780-1781       V21245 1782-1783
   V21246 1784-1785       V21247 1786            V21248 1787
   V21249 1788            V21250 1789            V21251 1790-1792
   V21252 1793-1795       V21253 1796-1799       V21254 1800-1801
   V21255 1802-1803       V21256 1804-1805       V21257 1806-1807
   V21258 1808            V21259 1809            V21260 1810
   V21261 1811            V21262 1812            V21263 1813
   V21264 1814            V21265 1815            V21266 1816
   V21267 1817            V21268 1818            V21269 1819
   V21270 1820            V21271 1821-1822       V21272 1823-1824
   V21273 1825            V21274 1826-1828       V21275 1829-1831
   V21276 1832-1835       V21277 1836-1837       V21278 1838-1839
   V21279 1840-1841       V21280 1842-1843       V21281 1844
   V21282 1845            V21283 1846            V21284 1847
   V21285 1848            V21286 1849            V21287 1850
   V21288 1851            V21289 1852            V21290 1853
   V21291 1854            V21292 1855            V21293 1856
   V21294 1857-1858       V21295 1859-1860       V21296 1861
   V21297 1862-1863       V21298 1864-1865       V21299 1866
   V21300 1867-1871       V21301 1872            V21302 1873-1878
   V21303 1879            V21304 1880-1881       V21305 1882
   V21306 1883            V21307 1884            V21308 1885
   V21309 1886-1891       V21310 1892-1897       V21311 1898
   V21312 1899            V21313 1900-1901       V21314 1902-1903
   V21315 1904-1905       V21316 1906-1907       V21317 1908
   V21318 1909            V21319 1910            V21320 1911
   V21321 1912            V21322 1913            V21323 1914
   V21324 1915            V21325 1916            V21326 1917
   V21327 1918            V21328 1919            V21329 1920
   V21330 1921            V21331 1922            V21332 1923
   V21333 1924            V21334 1925            V21335 1926
   V21336 1927            V21337 1928            V21338 1929
   V21339 1930            V21340 1931            V21341 1932
   V21342 1933            V21343 1934-1935       V21344 1936
   V21345 1937            V21346 1938-1939       V21347 1940
   V21348 1941            V21349 1942-1943       V21350 1944
   V21351 1945            V21352 1946-1947       V21353 1948
   V21354 1949            V21355 1950            V21356 1951
   V21357 1952            V21358 1953            V21359 1954-1955
   V21360 1956-1957       V21361 1958-1959       V21362 1960-1961
   V21363 1962-1963       V21364 1964-1965       V21365 1966
   V21366 1967-1968       V21367 1969            V21368 1970
   V21369 1971-1972       V21370 1973-1974       V21371 1975
   V21372 1976            V21373 1977            V21374 1978-1979
   V21375 1980-1981       V21376 1982-1983       V21377 1984
   V21378 1985-1986       V21379 1987-1988       V21380 1989-1990
   V21381 1991            V21382 1992-1993       V21383 1994-1995
   V21384 1996-1997       V21385 1998-1999       V21386 2000-2001
   V21387 2002-2003       V21388 2004            V21389 2005-2006
   V21390 2007-2009       V21391 2010-2011       V21392 2012-2014
   V21393 2015            V21394 2016            V21395 2017
   V21396 2018            V21397 2019-2020       V21398 2021-2023
   V21399 2024            V21400 2025            V21401 2026
   V21402 2027            V21403 2028            V21404 2029
   V21405 2030            V21406 2031            V21407 2032-2033
   V21408 2034            V21409 2035            V21410 2036-2037
   V21411 2038            V21412 2039            V21413 2040-2041
   V21414 2042            V21415 2043            V21416 2044-2045
   V21417 2046            V21418 2047            V21419 2048
   V21420 2049            V21421 2050            V21422 2051
   V21423 2052            V21424 2053-2054       V21425 2055-2056
   V21426 2057-2058       V21427 2059-2060       V21428 2061-2062
   V21429 2063-2064       V21430 2065-2066       V21431 2067-2068
   V21432 2069-2070       V21433 2071-2072       V21434 2073
   V21435 2074-2075       V21436 2076-2077       V21437 2078
   V21438 2079            V21439 2080-2081       V21440 2082-2083
   V21441 2084-2085       V21442 2086            V21443 2087
   V21444 2088            V21445 2089-2090       V21446 2091-2092
   V21447 2093-2094       V21448 2095-2096       V21449 2097
   V21450 2098-2099       V21451 2100-2101       V21452 2102-2103
   V21453 2104-2105       V21454 2106            V21455 2107-2108
   V21456 2109-2110       V21457 2111-2112       V21458 2113-2114
   V21459 2115-2116       V21460 2117-2118       V21461 2119-2120
   V21462 2121            V21463 2122-2123       V21464 2124
   V21465 2125            V21466 2126            V21467 2127-2128
   V21468 2129-2134       V21469 2135-2136       V21470 2137-2141
   V21471 2142-2143       V21472 2144-2148       V21473 2149-2150
   V21474 2151-2155       V21475 2156-2157       V21476 2158-2162
   V21477 2163-2164       V21478 2165-2169       V21479 2170-2171
   V21480 2172-2177       V21481 2178-2184       V21482 2185-2187
   V21483 2188-2190       V21484 2191-2196       V21485 2197-2199
   V21486 2200-2202       V21487 2203-2207 .2    V21488 2208-2212
   V21489 2213-2217 .2    V21490 2218-2222       V21491 2223-2226 .2
   V21492 2227-2230       V21493 2231-2234 .2    V21494 2235-2238 .2
   V21495 2239            V21496 2240-2241       V21497 2242-2244
   V21498 2245-2246       V21499 2247            V21500 2248
   V21501 2249            V21502 2250-2251       V21503 2252-2253
   V21504 2254-2255       V21505 2256-2257       V21506 2258
   V21507 2259            V21508 2260            V21509 2261
   V21510 2262            V21511 2263            V21512 2264
   V21513 2265            V21514 2266            V21515 2267
   V21516 2268            V21517 2269            V21518 2270
   V21519 2271            V21520 2272            V21521 2273-2274
   V21522 2275            V21523 2276            V21524 2277
   V21525 2278-2279       V21526 2280-2281       V21527 2282
   V21528 2283            V21529 2284-2288       V21530 2289-2293
   V21531 2294            V21532 2295-2296       V21533 2297-2301
   V21534 2302            V21535 2303-2304       V21536 2305-2309
   V21537 2310            V21538 2311-2312       V21539 2313-2317
   V21540 2318            V21541 2319-2320       V21542 2321-2325
   V21543 2326            V21544 2327            V21545 2328
   V21546 2329            V21547 2330-2335 .3    V21548 2336-2341 .3
   V21549 2342-2347 .3;

* SAS LABEL STATEMENT;

LABEL
   V20301 = "RELEASE NUMBER (2)"
   V20302 = "1992 INTERVIEW NUMBER"
   V20303 = "CURRENT STATE"
   V20304 = "CURRENT COUNTY"
   V20305 = "CURRENT STATE+CNTY"
   V20306 = "SIZE LGST CITY/COUNTY 92"
   V20307 = "SPLITOFF INDICATOR    92"
   V20308 = "WHETHER REFUSED       92"
   V20309 = "MODE OF INTERVIEW     92"
   V20310 = "FAM COMP CHANGE       92"
   V20311 = "NUMBER MOVED IN       92"
   V20312 = "WHO MOVED IN          92"
   V20313 = "NUMBER MOVED OUT      92"
   V20314 = "WHO MOVED OUT         92"
   V20315 = "CURRENT FAM COMP      92"
   V20316 = "CURRENT HSEHOLD COMP  92"
   V20317 = "68 ID# OF HOUSEHOLDER 92"
   V20318 = "PERS# OF HOUSEHOLDER  92"
   V20319 = "AGE OF HOUSEHOLDER    92"
   V20320 = "SEX OF HOUSEHOLDER    92"
   V20321 = "REL HHOLDER TO FU HD  92"
   V20322 = "QUALITY OF MATCH      92"
   V20323 = "TYPE INSTITUTION      92"
   V20324 = "1992 HOUSE VALUE  (A20)"
   V20325 = "ACC 92 HOUSE VALUE"
   V20326 = "1992 REM MORT PRIN (A24)"
   V20327 = "ACC REM MORT PRIN"
   V20328 = "TOTAL ANN MRTG PMT (A25)"
   V20329 = "ACC TOT ANN MRTG PMT"
   V20330 = "92 ANN PROP TAX (A21)"
   V20331 = "ACC ANN PROP TAX"
   V20332 = "ANN HOMEOWNER INS (A22)"
   V20333 = "ANN RENT (A31)"
   V20334 = "ACC ANN RENT"
   V20335 = "ANN VAL FREE HSNG (A37)"
   V20336 = "ACC ANN VAL FREE HSNG"
   V20337 = "GOV SUBSIDY OF HTG (A18)"
   V20338 = "HD MAIN JOB WRKHRS 91"
   V20339 = "ACC HD 91 MAIN JOB WRKHR"
   V20340 = "HD OVERTIME WRKHRS 91"
   V20341 = "ACC HD 91 OVERTIME WRKHR"
   V20342 = "HD XTRA JOB WRKHRS 91"
   V20343 = "ACC HD 91 XTRA JOB WRKHR"
   V20344 = "HD ANN WRK HRS IN 91"
   V20345 = "HD HRS WRK LOST OTR ILL"
   V20346 = "ACC HD HR LOST OTR ILL"
   V20347 = "HD HRS WRK LOST OWN ILL"
   V20348 = "ACC HD HRS LOST OWN ILL"
   V20349 = "HD STRIKE HOURS 91"
   V20350 = "ACC HD STRIKE HRS 91"
   V20351 = "HD UNEMP HRS 91"
   V20352 = "ACC 91 HD UNEMP HRS"
   V20353 = "HD HRS OUT LBR FORCE 91"
   V20354 = "ACC 91 HD HR OUT LBR FRC"
   V20355 = "HD UNEMP/OUT LBR JAN 91"
   V20356 = "HD UNEMP/OUT LBR FEB 91"
   V20357 = "HD UNEMP/OUT LBR MAR 91"
   V20358 = "HD UNEMP/OUT LBR APR 91"
   V20359 = "HD UNEMP/OUT LBR MAY 91"
   V20360 = "HD UNEMP/OUT LBR JUN 91"
   V20361 = "HD UNEMP/OUT LBR JUL 91"
   V20362 = "HD UNEMP/OUT LBR AUG 91"
   V20363 = "HD UNEMP/OUT LBR SEP 91"
   V20364 = "HD UNEMP/OUT LBR OCT 91"
   V20365 = "HD UNEMP/OUT LBR NOV 91"
   V20366 = "HD UNEMP/OUT LBR DEC 91"
   V20367 = "WIFE IN FU?"
   V20368 = "WF MAIN JOB WRKHRS 91"
   V20369 = "ACC WF 91 MAIN JOB WRKHR"
   V20370 = "WF OVERTIME WRKHRS 91"
   V20371 = "ACC WF 91 OVERTIME WRKHR"
   V20372 = "WF XTRA JOB WRKHRS 91"
   V20373 = "ACC WF 91 XTRA JOB WRKHR"
   V20374 = "WF ANN WRK HRS IN 91"
   V20375 = "WF HRS WRK LOST OTR ILL"
   V20376 = "ACC WF HR LOST OTR ILL"
   V20377 = "WF HRS WRK LOST OWN ILL"
   V20378 = "ACC WF HRS LOST OWN ILL"
   V20379 = "WF STRIKE HOURS 91"
   V20380 = "ACC WF STRIKE HRS 91"
   V20381 = "WF UNEMP HRS 91"
   V20382 = "ACC WF UNEMP HRS 91"
   V20383 = "WF HRS OUT LBR FORCE 91"
   V20384 = "ACC WF 91 HR OUT LBR FRC"
   V20385 = "WF UNEMP/OUT LBR JAN 91"
   V20386 = "WF UNEMP/OUT LBR FEB 91"
   V20387 = "WF UNEMP/OUT LBR MAR 91"
   V20388 = "WF UNEMP/OUT LBR APR 91"
   V20389 = "WF UNEMP/OUT LBR MAY 91"
   V20390 = "WF UNEMP/OUT LBR JUN 91"
   V20391 = "WF UNEMP/OUT LBR JUL 91"
   V20392 = "WF UNEMP/OUT LBR AUG 91"
   V20393 = "WF UNEMP/OUT LBR SEP 91"
   V20394 = "WF UNEMP/OUT LBR OCT 91"
   V20395 = "WF UNEMP/OUT LBR NOV 91"
   V20396 = "WF UNEMP/OUT LBR DEC 91"
   V20397 = "# MAJOR ADULTS"
   V20398 = "1992 FAMILY SIZE"
   V20399 = "# REQUIRED ROOMS"
   V20400 = "WIFE ANN HOUSEWORK  (F2)"
   V20401 = "ACC WIFE ANN HOUSEWORK"
   V20402 = "HEAD ANN HOUSEWORK  (F3)"
   V20403 = "ACC HEAD ANN HOUSEWORK"
   V20404 = "# IN HH GOT FD ST LST MO"
   V20405 = "VALUE FD ST LST MO (F10)"
   V20406 = "ACC VALUE FD ST LST MO"
   V20407 = "ANN FD COST-HOME"
   V20408 = "ACC HOME FD COST"
   V20409 = "ANN FD COST-EAT OUT"
   V20410 = "ACC EAT OUT FD COST"
   V20411 = "VALUE FD ST 91     (F21)"
   V20412 = "ACC VALUE FD ST 91"
   V20413 = "# MOS USED FD ST 91(F22)"
   V20414 = "WTR USED FD ST JAN 91"
   V20415 = "WTR USED FD ST FEB 91"
   V20416 = "WTR USED FD ST MAR 91"
   V20417 = "WTR USED FD ST APR 91"
   V20418 = "WTR USED FD ST MAY 91"
   V20419 = "WTR USED FD ST JUN 91"
   V20420 = "WTR USED FD ST JUL 91"
   V20421 = "WTR USED FD ST AUG 91"
   V20422 = "WTR USED FD ST SEP 91"
   V20423 = "WTR USED FD ST OCT 91"
   V20424 = "WTR USED FD ST NOV 91"
   V20425 = "WTR USED FD ST DEC 91"
   V20426 = "HD/WF HAVE TXBL Y?"
   V20427 = "LABOR PART FARM Y 91"
   V20428 = "LABOR PART BUS Y 91"
   V20429 = "HEAD 91 WAGES"
   V20430 = "ACC HEAD 91 WAGES"
   V20431 = "HD BONUS/OT/COMM 91"
   V20432 = "HD PROF PRAC/TRADE 91"
   V20433 = "LABOR PT MKT GARDEN 91"
   V20434 = "LABOR PT ROOMERS 91"
   V20435 = "ACC HD LABOR Y EXC WAGES"
   V20436 = "WIFE 91 LABOR/WAGE"
   V20437 = "ACC WF 91 LABOR/WAGE"
   V20438 = "ASSET PART FARM Y 91"
   V20439 = "ASSET PART BUS Y 91"
   V20440 = "ASSET PT MKT GARDN 91"
   V20441 = "ASSET PT ROOMERS 91"
   V20442 = "WF PT ASSET INCOME 91"
   V20443 = "HD # MO RECD RENT 91"
   V20444 = "HD RENT 91"
   V20445 = "HD # MO RECD INT/DIV 91"
   V20446 = "HD INT/DIVIDENDS 91"
   V20447 = "HD #MO RECD ALIMONY 91"
   V20448 = "ALIMONY Y HEAD 91"
   V20449 = "WF 91 OTHER ASSET Y"
   V20450 = "ACC H+W 91 ASSET Y"
   V20451 = "H+W 91 TAXABLE Y"
   V20452 = "H+W 91 SUPP OTR NONFU"
   V20453 = "H+W CHLD SUPPORT PAID 91"
   V20454 = "H+W ALIMONY PAID 91"
   V20455 = "XTRA XMPTS FOR BLIND"
   V20456 = "H+W TOTAL 91 EXEMPTION"
   V20457 = "1991 TAX TABLE USED-H+W"
   V20458 = "HD/WF REC TRANSFER Y 91?"
   V20459 = "HD 91 ADC/AFDC"
   V20460 = "ACC HD 91 ADC/AFDC"
   V20461 = "HD # MO RECEIVE SSI 91"
   V20462 = "HD 91 SSI"
   V20463 = "HD 91 OTR WELFARE"
   V20464 = "HD #MO RECD SOC SEC 91"
   V20465 = "HD 91 SOCIAL SECURITY"
   V20466 = "HD TYPE SOC SEC 91"
   V20467 = "HD #MO REC VA PENSION 91"
   V20468 = "HD 91 VA PENSION"
   V20469 = "HD #MO RECD OTR RET 91"
   V20470 = "HD OTHER RETIREMENT 91"
   V20471 = "HD # OTR PENS RCD 91"
   V20472 = "HD 91 UNEMP COMP"
   V20473 = "HD 91 WORKERS COMP"
   V20474 = "HD #MO REC CHILD SUPP 91"
   V20475 = "HD 91 CHILD SUPPORT"
   V20476 = "HD #MO REC HLP FR REL 91"
   V20477 = "HD 91 HELP FROM RELS"
   V20478 = "HD #MO REC OTR TRAN Y 91"
   V20479 = "HD 91 OTHER TRANSFER Y"
   V20480 = "WF 91 ADC/AFDC"
   V20481 = "ACC WF 91 ADC/AFDC"
   V20482 = "WF # MO RECEIVE SSI 91"
   V20483 = "WF 91 SSI"
   V20484 = "WF 91 OTR WELFARE"
   V20485 = "WF #MO RECD SOC SEC 91"
   V20486 = "WF 91 SOCIAL SECURITY"
   V20487 = "WF TYPE SOC SEC 91"
   V20488 = "WF #MO REC VA PENSION 91"
   V20489 = "WF 91 VA PENSION"
   V20490 = "WF #MO RECD OTR RET 91"
   V20491 = "WF OTHER RETIREMENT 91"
   V20492 = "WF 91 UNEMP COMP"
   V20493 = "WF 91 WORKERS COMP"
   V20494 = "WF #MO REC CHILD SUPP 91"
   V20495 = "WF 91 CHILD SUPPORT"
   V20496 = "WF #MO REC HLP FR REL 91"
   V20497 = "WF 91 HELP FROM RELS"
   V20498 = "WF #MO REC OTR TRAN Y 91"
   V20499 = "WF 91 OTHER TRANSFER Y"
   V20500 = "ACC H+W 91 TRANS EXC ADC"
   V20501 = "H+W 91 TOT TRANSFER Y"
   V20502 = "H+W RECD ADC/AFDC JAN 91"
   V20503 = "H+W RECD ADC/AFDC FEB 91"
   V20504 = "H+W RECD ADC/AFDC MAR 91"
   V20505 = "H+W RECD ADC/AFDC APR 91"
   V20506 = "H+W RECD ADC/AFDC MAY 91"
   V20507 = "H+W RECD ADC/AFDC JUN 91"
   V20508 = "H+W RECD ADC/AFDC JUL 91"
   V20509 = "H+W RECD ADC/AFDC AUG 91"
   V20510 = "H+W RECD ADC/AFDC SEP 91"
   V20511 = "H+W RECD ADC/AFDC OCT 91"
   V20512 = "H+W RECD ADC/AFDC NOV 91"
   V20513 = "H+W RECD ADC/AFDC DEC 91"
   V20514 = "H+W REC OTR WELFR JAN 91"
   V20515 = "H+W REC OTR WELFR FEB 91"
   V20516 = "H+W REC OTR WELFR MAR 91"
   V20517 = "H+W REC OTR WELFR APR 91"
   V20518 = "H+W REC OTR WELFR MAY 91"
   V20519 = "H+W REC OTR WELFR JUN 91"
   V20520 = "H+W REC OTR WELFR JUL 91"
   V20521 = "H+W REC OTR WELFR AUG 91"
   V20522 = "H+W REC OTR WELFR SEP 91"
   V20523 = "H+W REC OTR WELFR OCT 91"
   V20524 = "H+W REC OTR WELFR NOV 91"
   V20525 = "H+W REC OTR WELFR DEC 91"
   V20526 = "HD REC UNEMP COMP JAN 91"
   V20527 = "HD REC UNEMP COMP FEB 91"
   V20528 = "HD REC UNEMP COMP MAR 91"
   V20529 = "HD REC UNEMP COMP APR 91"
   V20530 = "HD REC UNEMP COMP MAY 91"
   V20531 = "HD REC UNEMP COMP JUN 91"
   V20532 = "HD REC UNEMP COMP JUL 91"
   V20533 = "HD REC UNEMP COMP AUG 91"
   V20534 = "HD REC UNEMP COMP SEP 91"
   V20535 = "HD REC UNEMP COMP OCT 91"
   V20536 = "HD REC UNEMP COMP NOV 91"
   V20537 = "HD REC UNEMP COMP DEC 91"
   V20538 = "WF REC UNEMP COMP JAN 91"
   V20539 = "WF REC UNEMP COMP FEB 91"
   V20540 = "WF REC UNEMP COMP MAR 91"
   V20541 = "WF REC UNEMP COMP APR 91"
   V20542 = "WF REC UNEMP COMP MAY 91"
   V20543 = "WF REC UNEMP COMP JUN 91"
   V20544 = "WF REC UNEMP COMP JUL 91"
   V20545 = "WF REC UNEMP COMP AUG 91"
   V20546 = "WF REC UNEMP COMP SEP 91"
   V20547 = "WF REC UNEMP COMP OCT 91"
   V20548 = "WF REC UNEMP COMP NOV 91"
   V20549 = "WF REC UNEMP COMP DEC 91"
   V20550 = "HD REC WORKR COMP JAN 91"
   V20551 = "HD REC WORKR COMP FEB 91"
   V20552 = "HD REC WORKR COMP MAR 91"
   V20553 = "HD REC WORKR COMP APR 91"
   V20554 = "HD REC WORKR COMP MAY 91"
   V20555 = "HD REC WORKR COMP JUN 91"
   V20556 = "HD REC WORKR COMP JUL 91"
   V20557 = "HD REC WORKR COMP AUG 91"
   V20558 = "HD REC WORKR COMP SEP 91"
   V20559 = "HD REC WORKR COMP OCT 91"
   V20560 = "HD REC WORKR COMP NOV 91"
   V20561 = "HD REC WORKR COMP DEC 91"
   V20562 = "WF REC WORKR COMP JAN 91"
   V20563 = "WF REC WORKR COMP FEB 91"
   V20564 = "WF REC WORKR COMP MAR 91"
   V20565 = "WF REC WORKR COMP APR 91"
   V20566 = "WF REC WORKR COMP MAY 91"
   V20567 = "WF REC WORKR COMP JUN 91"
   V20568 = "WF REC WORKR COMP JUL 91"
   V20569 = "WF REC WORKR COMP AUG 91"
   V20570 = "WF REC WORKR COMP SEP 91"
   V20571 = "WF REC WORKR COMP OCT 91"
   V20572 = "WF REC WORKR COMP NOV 91"
   V20573 = "WF REC WORKR COMP DEC 91"
   V20574 = "OFUM REC TXBL Y 91?"
   V20575 = "SEQ# 1ST OFUM W TXBL Y"
   V20576 = "%  PRORAT TXBL Y 1ST OFUM"
   V20577 = "TXBL Y 1ST XTRA EARNER"
   V20578 = "# EXEMP 1ST XTRA EARNER"
   V20579 = "TAX TABLE 1ST XTRA EARNR"
   V20580 = "SEQ# 2ND OFUM W TXBL Y"
   V20581 = "%  PRORAT TXBL Y 2ND OFUM"
   V20582 = "TXBL Y 2ND XTRA EARNER"
   V20583 = "# EXEMP 2ND XTRA EARNER"
   V20584 = "TAX TABLE 2ND XTRA EARNR"
   V20585 = "SEQ# 3RD OFUM W TXBL Y"
   V20586 = "%  PRORAT TXBL Y 3RD OFUM"
   V20587 = "TXBL Y 3RD XTRA EARNER"
   V20588 = "# EXEMP 3RD XTRA EARNER"
   V20589 = "TAX TABLE 3RD XTRA EARNR"
   V20590 = "SEQ# 4TH OFUM W TXBL Y"
   V20591 = "%  PRORAT TXBL Y 4TH OFUM"
   V20592 = "TXBL Y 4TH XTRA EARNER"
   V20593 = "# EXEMP 4TH XTRA EARNER"
   V20594 = "TAX TABLE 4TH XTRA EARNR"
   V20595 = "SEQ# 5TH OFUM W TXBL Y"
   V20596 = "%  PRORAT TXBL Y 5TH OFUM"
   V20597 = "TXBL Y 5TH XTRA EARNER"
   V20598 = "# EXEMP 5TH XTRA EARNER"
   V20599 = "TAX TABLE 5TH XTRA EARNR"
   V20600 = "OFUM 91 ANN WRK HRS"
   V20601 = "OFUM 91 TOT ANN TXBL Y"
   V20602 = "ACC OFUM ANN TXBL Y 91"
   V20603 = "OFUM 91 ASSET Y"
   V20604 = "OFUM REC TRANSFER Y?"
   V20605 = "OFUM 91 ADC/AFDC"
   V20606 = "OFUM 91 SSI"
   V20607 = "OFUM 91 OTHER WELFARE"
   V20608 = "OFUM 91 SOC SECURITY"
   V20609 = "OFUM 91 VA PAYMENTS"
   V20610 = "OFUM 91 OTR RETIREMENT"
   V20611 = "OFUM 91 UNEMP COMP"
   V20612 = "OFUM 91 WORKERS COMP"
   V20613 = "OFUM 91 CHILD SUPPORT"
   V20614 = "OFUM 91 HELP FROM RELS"
   V20615 = "OFUM 91 MISC TRANSFERS"
   V20616 = "NOPRO TOT TRANS Y OFUM91"
   V20617 = "PRO TOT TRANS Y OFUM 91"
   V20618 = "ACC OFUM 91 TRANSFERS"
   V20619 = "# OFUM Y RECEIVERS 91"
   V20620 = "# OFUM LABOR Y RECRS 91"
   V20621 = "1968 ID"
   V20622 = "1969 ID"
   V20623 = "1970 ID"
   V20624 = "1971 ID"
   V20625 = "1972 ID"
   V20626 = "1973 ID"
   V20627 = "1974 ID"
   V20628 = "1975 ID"
   V20629 = "1976 ID"
   V20630 = "1977 ID"
   V20631 = "1978 ID"
   V20632 = "1979 ID"
   V20633 = "1980 ID"
   V20634 = "1981 ID"
   V20635 = "1982 ID"
   V20636 = "1983 ID"
   V20637 = "1984 ID"
   V20638 = "1985 ID"
   V20639 = "1986 ID"
   V20640 = "1987 ID"
   V20641 = "1988 ID"
   V20642 = "1989 ID"
   V20643 = "1990 ID"
   V20644 = "1991 ID"
   V20645 = "LATINO TEMPLE CASE ID"
   V20646 = "INTERVIEWER ID # 1992"
   V20647 = "INTERVIEWER INTVIEW #"
   V20648 = "DATE OF 1992 IW"
   V20649 = "LENGTH OF 1992 IW"
   V20650 = "# IN FU"
   V20651 = "AGE OF 1992 HEAD"
   V20652 = "SEX OF 1992 HEAD"
   V20653 = "AGE OF 1992 WIFE"
   V20654 = "# CHILDREN IN FU"
   V20655 = "AGE YOUNGEST CHILD"
   V20656 = "# NONFU SHARING HU"
   V20657 = "A3 MARITAL STATUS"
   V20658 = "A4 TYPE DU"
   V20659 = "A6 LIVE IN ELDERLY HSNG"
   V20660 = "A7 TYPE ELDERLY HSNG"
   V20661 = "A8 PROVIDE MED/INJECTION"
   V20662 = "A9 PROVIDE MEALS"
   V20663 = "A10 PROVIDE CLEANING"
   V20664 = "A11 PROVIDE OTR SERVICES"
   V20665 = "A12 XTRA SERVS PROVIDED"
   V20666 = "A13 CKPOINT"
   V20667 = "A14 SERVICES INCLUDED"
   V20668 = "A15 TYPE HEATING #1"
   V20669 = "A15 TYPE HEATING #2"
   V20670 = "A16 ACTUAL # ROOMS"
   V20671 = "A17 RECD GOVT HTG SUBSDY"
   V20672 = "A19 OWN/RENT OR WHAT"
   V20673 = "A23 HAVE MORTGAGE?"
   V20674 = "A27 #YRS LEFT TO PAY MTG"
   V20675 = "A28 SECOND MORTGAGE?"
   V20676 = "A29 MTG INCL PROP TAXES"
   V20677 = "A30 MTG INCL INS PREM"
   V20678 = "A32 FURNISHED APT/HOUSE"
   V20679 = "A33 RENT INCL HEAT"
   V20680 = "A34 IN PUBLIC OWND PROJ?"
   V20681 = "A35 GOVT PAY PART RENT?"
   V20682 = "A36 WHY NOT OWN/RENT"
   V20683 = "A38 IN PUBLIC OWND PROJ?"
   V20684 = "A39 GOVT PAY ALL RENT?"
   V20685 = "A40 HAVE AIR CONDITNG"
   V20686 = "A41 A/C ALL OR SOME ROOM"
   V20687 = "A42 MOVED SINCE SPG 91?"
   V20688 = "A43 MONTH MOVED"
   V20689 = "A44 WHY MOVED"
   V20690 = "A45 WTR MIGHT MOVE"
   V20691 = "A46 LIKELIHOOD OF MOVING"
   V20692 = "A47 WHY MIGHT MOVE"
   V20693 = "B1 EMPLOYMENT STATUS-HD"
   V20694 = "B2 YEAR RETIRED   (HD-R)"
   V20695 = "B3 WORK FOR MONEY?(HD-E)"
   V20696 = "B4 WORK SELF/OTR? (HD-E)"
   V20697 = "B5 CORP/UNCORP BUS(HD-E)"
   V20698 = "B6 WORK FOR GOVT? (HD-E)"
   V20699 = "B7 JOB NOW UNION?  (H-E)"
   V20700 = "B8 BELONG UNION?  (HD-E)"
   V20701 = "B9-10 MAIN OCC:3 DIG H-E"
   V20702 = "B11 MAIN IND:3 DIGT(H-E)"
   V20703 = "B12 SLRY/HRLY/OTR  (H-E)"
   V20704 = "B13 PAY/HR-SALARY (HD-E)"
   V20705 = "B14 WTR SAL PD OT (HD-E)"
   V20706 = "B15 PAY/HR-SLRYOT (HD-E)"
   V20707 = "B16 PAY/HR-HOURLY (HD-E)"
   V20708 = "B17 PAY/HR-HRLY OT (H-E)"
   V20709 = "B18 HOW PAID-OTR  (HD-E)"
   V20710 = "B19 PAY/HR-OTR OT  (H-E)"
   V20711 = "B20 GET NEW JOB?  (HD-E)"
   V20712 = "B21 DONE NOTHING   (H-E)"
   V20713 = "B21 PUBLIC EMP AGCY(H-E)"
   V20714 = "B21 PRIVATE EMP AGY(H-E)"
   V20715 = "B21 PRES EMP DIRECT(H-E)"
   V20716 = "B21 OTR EMPR DIRECT(H-E)"
   V20717 = "B21 FRIEND OR REL  (H-E)"
   V20718 = "B21 PLACE OR ANS AD(H-E)"
   V20719 = "B21 OTHER          (H-E)"
   V20720 = "B23 #MO PRESENT EMP(H-E)"
   V20721 = "B24 MO BEG PRES EMP(H-E)"
   V20722 = "B24 YR BEG PRES EMP(H-E)"
   V20723 = "B25 BEG WRK PRES POS H-E"
   V20724 = "B26 MO BEG PRES POS(H-E)"
   V20725 = "B26 YR BEG PRES POS(H-E)"
   V20726 = "B27 CHGE POS IN 91(HD-E)"
   V20727 = "B28 MO CHGE POS   (HD-E)"
   V20728 = "B29 TYPE OF CHGE  (HD-E)"
   V20729 = "B30 MO BEG PRES POS(H-E)"
   V20730 = "B30 YR BEG PRES POS(H-E)"
   V20731 = "B31 MO BEG PRES POS(H-E)"
   V20732 = "B31 YR BEG PRES POS(H-E)"
   V20733 = "B32 CHGE POS IN 91(HD-E)"
   V20734 = "B33 MO CHGE POS   (HD-E)"
   V20735 = "B34 TYPE OF CHGE  (HD-E)"
   V20736 = "B35-36 BEG OCC PRES EMP"
   V20737 = "B37 STARTING WAGE  (H-E)"
   V20738 = "B38 STARTING HR/WK (H-E)"
   V20739 = "B39 PRES EMP JAN91 (H-E)"
   V20740 = "B39 PRES EMP FEB91 (H-E)"
   V20741 = "B39 PRES EMP MAR91 (H-E)"
   V20742 = "B39 PRES EMP APR91 (H-E)"
   V20743 = "B39 PRES EMP MAY91 (H-E)"
   V20744 = "B39 PRES EMP JUN91 (H-E)"
   V20745 = "B39 PRES EMP JUL91 (H-E)"
   V20746 = "B39 PRES EMP AUG91 (H-E)"
   V20747 = "B39 PRES EMP SEP91 (H-E)"
   V20748 = "B39 PRES EMP OCT91 (H-E)"
   V20749 = "B39 PRES EMP NOV91 (H-E)"
   V20750 = "B39 PRES EMP DEC91 (H-E)"
   V20751 = "B40 OTR EMP 1991  (HD-E)"
   V20752 = "B41 MO BEG OTR EMP  HD-E"
   V20753 = "B41 YR BEG OTR EMP  HD-E"
   V20754 = "B42 OTR EMP JAN91  (H-E)"
   V20755 = "B42 OTR EMP FEB91  (H-E)"
   V20756 = "B42 OTR EMP MAR91  (H-E)"
   V20757 = "B42 OTR EMP APR91  (H-E)"
   V20758 = "B42 OTR EMP MAY91  (H-E)"
   V20759 = "B42 OTR EMP JUN91  (H-E)"
   V20760 = "B42 OTR EMP JUL91  (H-E)"
   V20761 = "B42 OTR EMP AUG91  (H-E)"
   V20762 = "B42 OTR EMP SEP91  (H-E)"
   V20763 = "B42 OTR EMP OCT91  (H-E)"
   V20764 = "B42 OTR EMP NOV91  (H-E)"
   V20765 = "B42 OTR EMP DEC91  (H-E)"
   V20766 = "B43 WORK SELF/OTR?(HD-E)"
   V20767 = "B44 CORP/UNCORP BUS(H-E)"
   V20768 = "B45 WORK FOR GOVT?(HD-E)"
   V20769 = "B46-47 OCC OTR EMP (H-E)"
   V20770 = "B48 IND OTR EMP    (H-E)"
   V20771 = "B49 START WAGE OTR EMP H"
   V20772 = "B50 BEG HR/WK OTR EMP HD"
   V20773 = "B51 CHG POS OTR EMP(H-E)"
   V20774 = "B52 MO CHGE POS   (HD-E)"
   V20775 = "B53 TYPE CHG OTR EMP H-E"
   V20776 = "B54 STOP WRK OTR EMP H-E"
   V20777 = "B55 MO END OTR EMP (H-E)"
   V20778 = "B55 YR END OTR EMP (H-E)"
   V20779 = "B56 WHY LEFT OTR EMP H-E"
   V20780 = "B57 END WAGE OTR EMP H-E"
   V20781 = "B58 END HR/WK OTR EMP HD"
   V20782 = "B59 ANY OTR EMP 91 (H-E)"
   V20783 = "B-# WRK HIST SUPPS (H-E)"
   V20784 = "B60 WTR OTRS ILL  (HD-E)"
   V20785 = "B61 # WKS OTR ILL (HD-E)"
   V20786 = "B63 WTR SELF ILL  (HD-E)"
   V20787 = "B64 # WKS SELF ILL(HD-E)"
   V20788 = "B66 WTR VACATION  (HD-E)"
   V20789 = "B67 # WK VACATION (HD-E)"
   V20790 = "B69 WTR STRIKE    (HD-E)"
   V20791 = "B70 # WK ON STRIKE (H-E)"
   V20792 = "B72 WTR UNEMPLOYED(HD-E)"
   V20793 = "B73 # WK UNEMPLOYED(H-E)"
   V20794 = "B75 WTR OUT LAB FRC(H-E)"
   V20795 = "B76 #WK OUT LAB FRC(H-E)"
   V20796 = "B78 # WKS WORKED  (HD-E)"
   V20797 = "B79 # HR/WK WORKED (H-E)"
   V20798 = "B80 WTR WORKED OT (HD-E)"
   V20799 = "B82 WTR XTRA JOBS (HD-E)"
   V20800 = "B94-106 # XTRA JOBS(H-E)"
   V20801 = "B83 WORK FOR GOVT?(HD-E)"
   V20802 = "B84-85 OCC-XTRA JOB1 H-E"
   V20803 = "B86 IND XTRA JOB1  (H-E)"
   V20804 = "B87 PAY/HR XTRA JB1(H-E)"
   V20805 = "B88 # WKS XTRA JOB1(H-E)"
   V20806 = "B89 HR/WK XTRA JOB1(H-E)"
   V20807 = "B90 MO BEG XTRA JOB1 H-E"
   V20808 = "B90 YR BEG XTRA JOB1 H-E"
   V20809 = "B91 WRK XJB1 JAN91 (H-E)"
   V20810 = "B91 WRK XJB1 FEB91 (H-E)"
   V20811 = "B91 WRK XJB1 MAR91 (H-E)"
   V20812 = "B91 WRK XJB1 APR91 (H-E)"
   V20813 = "B91 WRK XJB1 MAY91 (H-E)"
   V20814 = "B91 WRK XJB1 JUN91 (H-E)"
   V20815 = "B91 WRK XJB1 JUL91 (H-E)"
   V20816 = "B91 WRK XJB1 AUG91 (H-E)"
   V20817 = "B91 WRK XJB1 SEP91 (H-E)"
   V20818 = "B91 WRK XJB1 OCT91 (H-E)"
   V20819 = "B91 WRK XJB1 NOV91 (H-E)"
   V20820 = "B91 WRK XJB1 DEC91 (H-E)"
   V20821 = "B92 STOP WRK XJOB1 (H-E)"
   V20822 = "B93 MO END XJOB1  (HD-E)"
   V20823 = "B93 YR END XJOB1  (HD-E)"
   V20824 = "B95 WRK FOR GOV XJB2 H-E"
   V20825 = "B95-97 OCC-XTRA JOB2 H-E"
   V20826 = "B98 IND XTRA JOB2  (H-E)"
   V20827 = "B99 AV PY/HR X JB2+(H-E)"
   V20828 = "B100 #WKS XTRA JB2+(H-E)"
   V20829 = "B101 AV HR/WK X JB2+ H-E"
   V20830 = "B102 MO BEG XJOB2  (H-E)"
   V20831 = "B102 YR BEG XJOB2  (H-E)"
   V20832 = "B103 WRK XJOB2 JAN91 H-E"
   V20833 = "B103 WRK XJOB2 FEB91 H-E"
   V20834 = "B103 WRK XJOB2 MAR91 H-E"
   V20835 = "B103 WRK XJOB2 APR91 H-E"
   V20836 = "B103 WRK XJOB2 MAY91 H-E"
   V20837 = "B103 WRK XJOB2 JUN91 H-E"
   V20838 = "B103 WRK XJOB2 JUL91 H-E"
   V20839 = "B103 WRK XJOB2 AUG91 H-E"
   V20840 = "B103 WRK XJOB2 SEP91 H-E"
   V20841 = "B103 WRK XJOB2 OCT91 H-E"
   V20842 = "B103 WRK XJOB2 NOV91 H-E"
   V20843 = "B103 WRK XJOB2 DEC91 H-E"
   V20844 = "B104 STOP WORK XJOB2 H-E"
   V20845 = "B105 MO END XJOB2 (HD-E)"
   V20846 = "B105 YR END XJOB2 (HD-E)"
   V20847 = "C1 WTR LOOK FOR JOB(H-U)"
   V20848 = "C2 DONE NOTHING   (HD-U)"
   V20849 = "C2 PUBLIC EMP AGCY (H-U)"
   V20850 = "C2 PRIVATE EMP AGY (H-U)"
   V20851 = "C2 PREV EMP DIRECT (H-U)"
   V20852 = "C2 OTR EMPR DIRECT (H-U)"
   V20853 = "C2 FRIEND OR REL   (H-U)"
   V20854 = "C2 PLACE OR ANS AD (H-U)"
   V20855 = "C2 OTHER           (H-U)"
   V20856 = "C3 HOW LONG LOOK WRK H-U"
   V20857 = "C4 EVER WORKED?   (HD-U)"
   V20858 = "C5 MO LAST WORKED (HD-U)"
   V20859 = "C5 YR LAST WORKED (HD-U)"
   V20860 = "C6 WTR UNEMP 91    (H-U)"
   V20861 = "C7 # WK UNEMP 91   (H-U)"
   V20862 = "C9-10 OCC-LAST JOB (H-U)"
   V20863 = "C11 IND-LAST JOB  (HD-U)"
   V20864 = "C12 WRK SELF/OTR? (HD-U)"
   V20865 = "C13 CORP/UNCORP BUS(H-U)"
   V20866 = "C14 WORK FOR GOVT? (H-U)"
   V20867 = "C15 WHY LAST JOB END H-U"
   V20868 = "C16 MO BEG LAST EMP  H-U"
   V20869 = "C16 YR BEG LAST EMP  H-U"
   V20870 = "C17 BEG WK LAST POS(H-U)"
   V20871 = "C18 MO BEG LAST POS  H-U"
   V20872 = "C18 YR BEG LAST POS  H-U"
   V20873 = "C19 CHGE POS IN 91(HD-U)"
   V20874 = "C20 MO CHGE POS   (HD-U)"
   V20875 = "C21 TYPE OF CHGE  (HD-U)"
   V20876 = "C22 MO BEG LAST POS(H-U)"
   V20877 = "C22 YR BEG LAST POS(H-U)"
   V20878 = "C23 MO BEG LAST POS(H-U)"
   V20879 = "C23 YR BEG LAST POS(H-U)"
   V20880 = "C24 CHGE POS IN 91(HD-U)"
   V20881 = "C25 MO CHGE POS   (HD-U)"
   V20882 = "C26 TYPE OF CHGE  (HD-U)"
   V20883 = "C27-28 BEG OCC LAST EMP"
   V20884 = "C29 WAGE BEG LAST EMP HD"
   V20885 = "C30 HR/WK BEG LAST EMP H"
   V20886 = "C31 LAST EMP JAN91 (H-U)"
   V20887 = "C31 LAST EMP FEB91 (H-U)"
   V20888 = "C31 LAST EMP MAR91 (H-U)"
   V20889 = "C31 LAST EMP APR91 (H-U)"
   V20890 = "C31 LAST EMP MAY91 (H-U)"
   V20891 = "C31 LAST EMP JUN91 (H-U)"
   V20892 = "C31 LAST EMP JUL91 (H-U)"
   V20893 = "C31 LAST EMP AUG91 (H-U)"
   V20894 = "C31 LAST EMP SEP91 (H-U)"
   V20895 = "C31 LAST EMP OCT91 (H-U)"
   V20896 = "C31 LAST EMP NOV91 (H-U)"
   V20897 = "C31 LAST EMP DEC91 (H-U)"
   V20898 = "C32 OTR EMP 1991  (HD-U)"
   V20899 = "C33 MO BEG OTR EMP(HD-U)"
   V20900 = "C33 YR BEG OTR EMP(HD-U)"
   V20901 = "C34 OTR EMP JAN91  (H-U)"
   V20902 = "C34 OTR EMP FEB91  (H-U)"
   V20903 = "C34 OTR EMP MAR91  (H-U)"
   V20904 = "C34 OTR EMP APR91  (H-U)"
   V20905 = "C34 OTR EMP MAY91  (H-U)"
   V20906 = "C34 OTR EMP JUN91  (H-U)"
   V20907 = "C34 OTR EMP JUL91  (H-U)"
   V20908 = "C34 OTR EMP AUG91  (H-U)"
   V20909 = "C34 OTR EMP SEP91  (H-U)"
   V20910 = "C34 OTR EMP OCT91  (H-U)"
   V20911 = "C34 OTR EMP NOV91  (H-U)"
   V20912 = "C34 OTR EMP DEC91  (H-U)"
   V20913 = "C35 WORK SELF/OTR?(HD-U)"
   V20914 = "C36 CORP/UNCORP BUS(H-U)"
   V20915 = "C37 WRK GOV-OTR EMP? H-U"
   V20916 = "C38-39 OCC OTR EMP (H-U)"
   V20917 = "C40 IND OTR EMP   (HD-U)"
   V20918 = "C41 START WAGE OTR EMP H"
   V20919 = "C42 BEG HR/WK OTR EMP HD"
   V20920 = "C43 CHG POS OTR EMP(H-U)"
   V20921 = "C44 MO CHGE POS   (HD-U)"
   V20922 = "C45 TYPE CHG OTR EMP H-U"
   V20923 = "C46 STOP WRK OTR EMP H-U"
   V20924 = "C47 MO END OTR EMP  HD-U"
   V20925 = "C47 YR END OTR EMP  HD-U"
   V20926 = "C48 WHY LEFT OTR EMP H-U"
   V20927 = "C49 END WAGE OTR EMP H-U"
   V20928 = "C50 END HRS/WK OTR EMP H"
   V20929 = "C51 ANY OTR EMP 91 (H-U)"
   V20930 = "C-# WORK HIST SUPPS(H-U)"
   V20931 = "C52 WTR VACATION  (HD-U)"
   V20932 = "C53 #WKS VACATION (HD-U)"
   V20933 = "C55 WTR OTRS ILL  (HD-U)"
   V20934 = "C56 #WKS OTRS ILL (HD-U)"
   V20935 = "C58 WTR SELF ILL  (HD-U)"
   V20936 = "C59 #WKS SELF ILL (HD-U)"
   V20937 = "C61 WTR ON STRIKE (HD-U)"
   V20938 = "C62 #WKS ON STRIKE (H-U)"
   V20939 = "C64 WTR UNEMPLOYED (H-U)"
   V20940 = "C65 #WK UNEMPLOYED (H-U)"
   V20941 = "C67 WTR OUT LAB FRC(H-U)"
   V20942 = "C68 #WKS OUT LAB FRC H-U"
   V20943 = "C70 # WKS WORKED  (HD-U)"
   V20944 = "C71 HR/WK WORKED  (HD-U)"
   V20945 = "C72 WTR WORKED OT (HD-U)"
   V20946 = "C74 WTR XTRA JOBS (HD-U)"
   V20947 = "C74-98 # XTRA JOBS (H-U)"
   V20948 = "C75 WORK FOR GOVT?(HD-U)"
   V20949 = "C76-77 OCC-XTRA JOB1 H-U"
   V20950 = "C78 IND XTRA JOB1 (HD-U)"
   V20951 = "C79 PAY/HR XTRA JOB1 H-U"
   V20952 = "C80 # WKS EXTRA JOB1 H-U"
   V20953 = "C81 HR/WK XTRA JOB1(H-U)"
   V20954 = "C82 MO BEG XTRA JOB1 H-U"
   V20955 = "C82 YR BEG XTRA JOB1 H-U"
   V20956 = "C83 WRK XJOB1 JAN91  H-U"
   V20957 = "C83 WRK XJOB1 FEB91  H-U"
   V20958 = "C83 WRK XJOB1 MAR91  H-U"
   V20959 = "C83 WRK XJOB1 APR91  H-U"
   V20960 = "C83 WRK XJOB1 MAY91  H-U"
   V20961 = "C83 WRK XJOB1 JUN91  H-U"
   V20962 = "C83 WRK XJOB1 JUL91  H-U"
   V20963 = "C83 WRK XJOB1 AUG91  H-U"
   V20964 = "C83 WRK XJOB1 SEP91  H-U"
   V20965 = "C83 WRK XJOB1 OCT91  H-U"
   V20966 = "C83 WRK XJOB1 NOV91  H-U"
   V20967 = "C83 WRK XJOB1 DEC91  H-U"
   V20968 = "C84 STOP WORK XJOB1 H-U"
   V20969 = "C85 MO END XJOB1  (HD-U)"
   V20970 = "C85 YR END XJOB1  (HD-U)"
   V20971 = "C87 WRK FOR GOV XJB2 H-U"
   V20972 = "C88-89 OCC-XTRA JB2(H-U)"
   V20973 = "C90 IND XTRA JOB2  (H-U)"
   V20974 = "C91 AV PY/HR X JB2+(H-U)"
   V20975 = "C92 # WK XTRA JOB2+(H-U)"
   V20976 = "C93 AV HR/WK X JB2+(H-U)"
   V20977 = "C94 MO BEG XJOB2   (H-U)"
   V20978 = "C94 YR BEG XJOB2   (H-U)"
   V20979 = "C95 WRK XJOB2 JAN91  H-U"
   V20980 = "C95 WRK XJOB2 FEB91  H-U"
   V20981 = "C95 WRK XJOB2 MAR91  H-U"
   V20982 = "C95 WRK XJOB2 APR91  H-U"
   V20983 = "C95 WRK XJOB2 MAY91  H-U"
   V20984 = "C95 WRK XJOB2 JUN91  H-U"
   V20985 = "C95 WRK XJOB2 JUL91  H-U"
   V20986 = "C95 WRK XJOB2 AUG91  H-U"
   V20987 = "C95 WRK XJOB2 SEP91  H-U"
   V20988 = "C95 WRK XJOB2 OCT91  H-U"
   V20989 = "C95 WRK XJOB2 NOV91  H-U"
   V20990 = "C95 WRK XJOB2 DEC91  H-U"
   V20991 = "C96 STOP WORK XJOB2 H-U"
   V20992 = "C97 MO END JOB2   (HD-U)"
   V20993 = "C97 YR END JOB2   (HD-U)"
   V20994 = "D1 CHKPT"
   V20995 = "D1A EMPLOYMENT STATUS-WF"
   V20996 = "D2 YEAR RETIRED   (WF-R)"
   V20997 = "D3 WORK FOR MONEY?(WF-E)"
   V20998 = "D4 WORK SELF/OTR? (WF-E)"
   V20999 = "D5 CORP/UNCORP BUS(WF-E)"
   V21000 = "D6 WORK FOR GOVT? (WF-E)"
   V21001 = "D7 JOB NOW UNION?  (W-E)"
   V21002 = "D8 BELONG UNION?  (WF-E)"
   V21003 = "D9-10 MAIN OCC:3 DIG W-E"
   V21004 = "D11 MAIN IND:3 DIGT(W-E)"
   V21005 = "D12 SLRY/HRLY/OTR  (W-E)"
   V21006 = "D13 PAY/HR-SALARY (WF-E)"
   V21007 = "D14 WTR SAL PD OT (WF-E)"
   V21008 = "D15 PAY/HR-SLRYOT (WF-E)"
   V21009 = "D16 PAY/HR-HOURLY (WF-E)"
   V21010 = "D17 PAY/HR-HRLY OT (W-E)"
   V21011 = "D18 HOW PAID-OTR  (WF-E)"
   V21012 = "D19 PAY/HR-OTR OT  (W-E)"
   V21013 = "D20 GET NEW JOB?  (WF-E)"
   V21014 = "D21 DONE NOTHING   (W-E)"
   V21015 = "D21 PUBLIC EMP AGCY(W-E)"
   V21016 = "D21 PRIVATE EMP AGY(W-E)"
   V21017 = "D21 PRES EMP DIRECT(W-E)"
   V21018 = "D21 OTR EMPR DIRECT(W-E)"
   V21019 = "D21 FRIEND OR REL  (W-E)"
   V21020 = "D21 PLACE OR ANS AD(W-E)"
   V21021 = "D21 OTHER          (W-E)"
   V21022 = "D23 #MO PRESENT EMP(W-E)"
   V21023 = "D24 MO BEG PRES EMP(W-E)"
   V21024 = "D24 YR BEG PRES EMP(W-E)"
   V21025 = "D25 BEG WRK PRES POS W-E"
   V21026 = "D26 MO BEG PRES POS(W-E)"
   V21027 = "D26 YR BEG PRES POS(W-E)"
   V21028 = "D27 CHGE POS IN 91(WF-E)"
   V21029 = "D28 MO CHGE POS   (WF-E)"
   V21030 = "D29 TYPE OF CHGE  (WF-E)"
   V21031 = "D30 MO BEG PRES POS(W-E)"
   V21032 = "D30 YR BEG PRES POS(W-E)"
   V21033 = "D31 MO BEG PRES POS(W-E)"
   V21034 = "D31 YR BEG PRES POS(W-E)"
   V21035 = "D32 CHGE POS IN 91(WF-E)"
   V21036 = "D33 MO CHGE POS   (WF-E)"
   V21037 = "D34 TYPE OF CHGE  (WF-E)"
   V21038 = "D35-36 BEG OCC PRES EMP"
   V21039 = "D37 STARTING WAGE  (W-E)"
   V21040 = "D38 STARTING HR/WK (W-E)"
   V21041 = "D39 PRES EMP JAN91 (W-E)"
   V21042 = "D39 PRES EMP FEB91 (W-E)"
   V21043 = "D39 PRES EMP MAR91 (W-E)"
   V21044 = "D39 PRES EMP APR91 (W-E)"
   V21045 = "D39 PRES EMP MAY91 (W-E)"
   V21046 = "D39 PRES EMP JUN91 (W-E)"
   V21047 = "D39 PRES EMP JUL91 (W-E)"
   V21048 = "D39 PRES EMP AUG91 (W-E)"
   V21049 = "D39 PRES EMP SEP91 (W-E)"
   V21050 = "D39 PRES EMP OCT91 (W-E)"
   V21051 = "D39 PRES EMP NOV91 (W-E)"
   V21052 = "D39 PRES EMP DEC91 (W-E)"
   V21053 = "D40 OTR EMP 1991  (WF-E)"
   V21054 = "D41 MO BEG OTR EMP(WF-E)"
   V21055 = "D41 YR BEG OTR EMP(WF-E)"
   V21056 = "D42 OTR EMP JAN91  (W-E)"
   V21057 = "D42 OTR EMP FEB91  (W-E)"
   V21058 = "D42 OTR EMP MAR91  (W-E)"
   V21059 = "D42 OTR EMP APR91  (W-E)"
   V21060 = "D42 OTR EMP MAY91  (W-E)"
   V21061 = "D42 OTR EMP JUN91  (W-E)"
   V21062 = "D42 OTR EMP JUL91  (W-E)"
   V21063 = "D42 OTR EMP AUG91  (W-E)"
   V21064 = "D42 OTR EMP SEP91  (W-E)"
   V21065 = "D42 OTR EMP OCT91  (W-E)"
   V21066 = "D42 OTR EMP NOV91  (W-E)"
   V21067 = "D42 OTR EMP DEC91  (W-E)"
   V21068 = "D43 WORK SELF/OTR?(WF-E)"
   V21069 = "D44 CORP/UNCORP BUS(W-E)"
   V21070 = "D45 WORK FOR GOVT?(WF-E)"
   V21071 = "D46-47 OCC OTR EMP (W-E)"
   V21072 = "D48 IND OTR EMP    (W-E)"
   V21073 = "D49 START WAGE OTR EMP W"
   V21074 = "D50 BEG HR/WK OTR EMP WF"
   V21075 = "D51 CHG POS OTR EMP(W-E)"
   V21076 = "D52 MO CHGE POS   (WF-E)"
   V21077 = "D53 TYPE CHG OTR EMP W-E"
   V21078 = "D54 STOP WRK OTR EMP W-E"
   V21079 = "D55 MO END OTR EMP (W-E)"
   V21080 = "D55 YR END OTR EMP (W-E)"
   V21081 = "D56 WHY LEFT OTR EMP W-E"
   V21082 = "D57 END WAGE OTR EMP W-E"
   V21083 = "D58 END HR/WK OTR EMP WF"
   V21084 = "D59 ANY OTR EMP 91 (W-E)"
   V21085 = "D-# WRK HIST SUPPS (W-E)"
   V21086 = "D60 WTR OTRS ILL  (WF-E)"
   V21087 = "D61 # WKS OTR ILL (WF-E)"
   V21088 = "D63 WTR SELF ILL  (WF-E)"
   V21089 = "D64 # WKS SELF ILL(WF-E)"
   V21090 = "D66 WTR VACATION  (WF-E)"
   V21091 = "D67 # WK VACATION (WF-E)"
   V21092 = "D69 WTR STRIKE    (WF-E)"
   V21093 = "D70 # WK ON STRIKE (W-E)"
   V21094 = "D72 WTR UNEMPLOYED(WF-E)"
   V21095 = "D73 # WK UNEMPLOYED(W-E)"
   V21096 = "D75 WTR OUT LAB FRC(W-E)"
   V21097 = "D76 #WK OUT LAB FRC(W-E)"
   V21098 = "D78 # WKS WORKED  (WF-E)"
   V21099 = "D79 # HR/WK WORKED (W-E)"
   V21100 = "D80 WTR WORKED OT (WF-E)"
   V21101 = "D82 WTR XTRA JOBS (WF-E)"
   V21102 = "D82-106 # XTRA JOBS(W-E)"
   V21103 = "D83 WORK FOR GOVT?(WF-E)"
   V21104 = "D84-85 OCC-XTRA JOB1 W-E"
   V21105 = "D86 IND XTRA JOB1  (W-E)"
   V21106 = "D87 PAY/HR XTRA JB1(W-E)"
   V21107 = "D88 # WKS XTRA JOB1(W-E)"
   V21108 = "D89 HR/WK XTRA JOB1(W-E)"
   V21109 = "D90 MO BEG XTRA JOB1 W-E"
   V21110 = "D90 YR BEG XTRA JOB1 W-E"
   V21111 = "D91 WRK XJB1 JAN91 (W-E)"
   V21112 = "D91 WRK XJB1 FEB91 (W-E)"
   V21113 = "D91 WRK XJB1 MAR91 (W-E)"
   V21114 = "D91 WRK XJB1 APR91 (W-E)"
   V21115 = "D91 WRK XJB1 MAY91 (W-E)"
   V21116 = "D91 WRK XJB1 JUN91 (W-E)"
   V21117 = "D91 WRK XJB1 JUL91 (W-E)"
   V21118 = "D91 WRK XJB1 AUG91 (W-E)"
   V21119 = "D91 WRK XJB1 SEP91 (W-E)"
   V21120 = "D91 WRK XJB1 OCT91 (W-E)"
   V21121 = "D91 WRK XJB1 NOV91 (W-E)"
   V21122 = "D91 WRK XJB1 DEC91 (W-E)"
   V21123 = "D92 STOP WRK XJOB1 (W-E)"
   V21124 = "D93 MO END XJOB1  (WF-E)"
   V21125 = "D93 YR END XJOB1  (WF-E)"
   V21126 = "D95 WRK FOR GOV XJB2 W-E"
   V21127 = "D95-97 OCC-XTRA JOB2 W-E"
   V21128 = "D98 IND XTRA JOB2  (W-E)"
   V21129 = "D99 AV PY/HR X JB2+(W-E)"
   V21130 = "D100 #WKS XTRA JB2+(W-E)"
   V21131 = "D101 AV HR/WK X JB2+ W-E"
   V21132 = "D102 MO BEG XJOB2  (W-E)"
   V21133 = "D102 YR BEG XJOB2  (W-E)"
   V21134 = "D103 WRK XJOB2 JAN91 W-E"
   V21135 = "D103 WRK XJOB2 FEB91 W-E"
   V21136 = "D103 WRK XJOB2 MAR91 W-E"
   V21137 = "D103 WRK XJOB2 APR91 W-E"
   V21138 = "D103 WRK XJOB2 MAY91 W-E"
   V21139 = "D103 WRK XJOB2 JUN91 W-E"
   V21140 = "D103 WRK XJOB2 JUL91 W-E"
   V21141 = "D103 WRK XJOB2 AUG91 W-E"
   V21142 = "D103 WRK XJOB2 SEP91 W-E"
   V21143 = "D103 WRK XJOB2 OCT91 W-E"
   V21144 = "D103 WRK XJOB2 NOV91 W-E"
   V21145 = "D103 WRK XJOB2 DEC91 W-E"
   V21146 = "D104 STOP WRK XJOB2 W-E"
   V21147 = "D105 MO END XJOB2 (WF-E)"
   V21148 = "D105 YR END XJOB2 (WF-E)"
   V21149 = "E1 WTR LOOK FOR JOB(W-U)"
   V21150 = "E2 DONE NOTHING   (WF-U)"
   V21151 = "E2 PUBLIC EMP AGCY (W-U)"
   V21152 = "E2 PRIVATE EMP AGY (W-U)"
   V21153 = "E2 PREV EMP DIRECT (W-U)"
   V21154 = "E2 OTR EMPR DIRECT (W-U)"
   V21155 = "E2 FRIEND OR REL   (W-U)"
   V21156 = "E2 PLACE OR ANS AD (W-U)"
   V21157 = "E2 OTHER           (W-U)"
   V21158 = "E3 HOW LONG LOOK WRK W-U"
   V21159 = "E4 EVER WORKED?   (WF-U)"
   V21160 = "E5 MO LAST WORKED (WF-U)"
   V21161 = "E5 YR LAST WORKED (WF-U)"
   V21162 = "E6 WTR UNEMP 91    (W-U)"
   V21163 = "E7 # WK UNEMP 91   (W-U)"
   V21164 = "E9-10 OCC-LAST JOB (W-U)"
   V21165 = "E11 IND-LAST JOB  (WF-U)"
   V21166 = "E12 WRK SELF/OTR? (WF-U)"
   V21167 = "E13 CORP/UNCORP BUS(W-U)"
   V21168 = "E14 WORK FOR GOVT? (W-U)"
   V21169 = "E15 WHY LAST JOB END W-U"
   V21170 = "E16 MO BEG LAST EMP  W-U"
   V21171 = "E16 YR BEG LAST EMP  W-U"
   V21172 = "E17 BEG WK LAST POS(W-U)"
   V21173 = "E18 MO BEG LAST POS(W-U)"
   V21174 = "E18 YR BEG LAST POS(W-U)"
   V21175 = "E19 CHGE POS IN 91(WF-U)"
   V21176 = "E20 MO CHGE POS   (WF-U)"
   V21177 = "E21 TYPE OF CHGE  (WF-U)"
   V21178 = "E22 MO BEG LAST POS(W-U)"
   V21179 = "E22 YR BEG LAST POS(W-U)"
   V21180 = "E23 MO BEG LAST POS(W-U)"
   V21181 = "E23 YR BEG LAST POS(W-U)"
   V21182 = "E24 CHGE POS IN 91(WF-U)"
   V21183 = "E25 MO CHGE POS   (WF-U)"
   V21184 = "E26 TYPE OF CHGE  (WF-U)"
   V21185 = "E27-28 BEG OCC LAST EMP"
   V21186 = "E29 WAGE BEG LAST EMP WF"
   V21187 = "E30 HR/WK BEG LAST EMP W"
   V21188 = "E31 LAST EMP JAN91 (W-U)"
   V21189 = "E31 LAST EMP FEB91 (W-U)"
   V21190 = "E31 LAST EMP MAR91 (W-U)"
   V21191 = "E31 LAST EMP APR91 (W-U)"
   V21192 = "E31 LAST EMP MAY91 (W-U)"
   V21193 = "E31 LAST EMP JUN91 (W-U)"
   V21194 = "E31 LAST EMP JUL91 (W-U)"
   V21195 = "E31 LAST EMP AUG91 (W-U)"
   V21196 = "E31 LAST EMP SEP91 (W-U)"
   V21197 = "E31 LAST EMP OCT91 (W-U)"
   V21198 = "E31 LAST EMP NOV91 (W-U)"
   V21199 = "E31 LAST EMP DEC91 (W-U)"
   V21200 = "E32 OTR EMP 1991  (WF-U)"
   V21201 = "E33 MO BEG OTR EMP(WF-U)"
   V21202 = "E33 YR BEG OTR EMP(WF-U)"
   V21203 = "E34 OTR EMP JAN91  (W-U)"
   V21204 = "E34 OTR EMP FEB91  (W-U)"
   V21205 = "E34 OTR EMP MAR91  (W-U)"
   V21206 = "E34 OTR EMP APR91  (W-U)"
   V21207 = "E34 OTR EMP MAY91  (W-U)"
   V21208 = "E34 OTR EMP JUN91  (W-U)"
   V21209 = "E34 OTR EMP JUL91  (W-U)"
   V21210 = "E34 OTR EMP AUG91  (W-U)"
   V21211 = "E34 OTR EMP SEP91  (W-U)"
   V21212 = "E34 OTR EMP OCT91  (W-U)"
   V21213 = "E34 OTR EMP NOV91  (W-U)"
   V21214 = "E34 OTR EMP DEC91  (W-U)"
   V21215 = "E35 WORK SELF/OTR?(WF-U)"
   V21216 = "E36 CORP/UNCORP BUS(W-U)"
   V21217 = "E37 WRK GOV-OTR EMP? W-U"
   V21218 = "E38-39 OCC OTR EMP (W-U)"
   V21219 = "E40 IND OTR EMP   (WF-U)"
   V21220 = "E41 START WAGE OTR EMP W"
   V21221 = "E42 BEG HR/WK OTR EMP WF"
   V21222 = "E43 CHG POS OTR EMP(W-U)"
   V21223 = "E44 MO CHGE POS   (WF-U)"
   V21224 = "E45 TYPE CHG OTR EMP W-U"
   V21225 = "E46 STOP WRK OTR EMP W-U"
   V21226 = "E47 MO END OTR EMP(WF-U)"
   V21227 = "E47 YR END OTR EMP(WF-U)"
   V21228 = "E48 WHY LEFT OTR EMP W-U"
   V21229 = "E49 END WAGE OTR EMP W-U"
   V21230 = "E50 END HRS/WK OTR EMP W"
   V21231 = "E51 ANY OTR EMP 91 (W-U)"
   V21232 = "E-# WORK HIST SUPPS(W-U)"
   V21233 = "E52 WTR VACATION  (WF-U)"
   V21234 = "E53 #WKS VACATION (WF-U)"
   V21235 = "E55 WTR OTRS ILL  (WF-U)"
   V21236 = "E56 #WKS OTRS ILL (WF-U)"
   V21237 = "E58 WTR SELF ILL  (WF-U)"
   V21238 = "E59 #WKS SELF ILL (WF-U)"
   V21239 = "E61 WTR ON STRIKE (WF-U)"
   V21240 = "E62 #WKS ON STRIKE (W-U)"
   V21241 = "E64 WTR UNEMPLOYED (W-U)"
   V21242 = "E65 #WK UNEMPLOYED (W-U)"
   V21243 = "E67 WTR OUT LAB FRC(W-U)"
   V21244 = "E68 #WKS OUT LAB FRC W-U"
   V21245 = "E70 # WKS WORKED  (WF-U)"
   V21246 = "E71 HR/WK WORKED  (WF-U)"
   V21247 = "E72 WTR WORKED OT (WF-U)"
   V21248 = "E74 WTR XTRA JOBS (WF-U)"
   V21249 = "E74-98 # XTRA JOBS (W-U)"
   V21250 = "E75 WORK FOR GOVT?(WF-U)"
   V21251 = "E76-77 OCC-XTRA JOB1 W-U"
   V21252 = "E78 IND XTRA JOB1 (WF-U)"
   V21253 = "E79 PAY/HR XTRA JOB1 W-U"
   V21254 = "E80 # WKS EXTRA JOB1 W-U"
   V21255 = "E81 HR/WK XTRA JOB1(W-U)"
   V21256 = "E82 MO BEG XTRA JOB1 W-U"
   V21257 = "E82 YR BEG XTRA JOB1 W-U"
   V21258 = "E83 WRK XJOB1 JAN91  W-U"
   V21259 = "E83 WRK XJOB1 FEB91  W-U"
   V21260 = "E83 WRK XJOB1 MAR91  W-U"
   V21261 = "E83 WRK XJOB1 APR91  W-U"
   V21262 = "E83 WRK XJOB1 MAY91  W-U"
   V21263 = "E83 WRK XJOB1 JUN91  W-U"
   V21264 = "E83 WRK XJOB1 JUL91  W-U"
   V21265 = "E83 WRK XJOB1 AUG91  W-U"
   V21266 = "E83 WRK XJOB1 SEP91  W-U"
   V21267 = "E83 WRK XJOB1 OCT91  W-U"
   V21268 = "E83 WRK XJOB1 NOV91  W-U"
   V21269 = "E83 WRK XJOB1 DEC91  W-U"
   V21270 = "E84 STOP WORK XJOB1  W-U"
   V21271 = "E85 MO END XJOB1  (WF-U)"
   V21272 = "E85 YR END XJOB1  (WF-U)"
   V21273 = "E87 WRK FOR GOV XJB2 W-U"
   V21274 = "E88-89 OCC-XTRA JB2(W-U)"
   V21275 = "E90 IND XTRA JOB2  (W-U)"
   V21276 = "E91 AV PY/HR X JB2+(W-U)"
   V21277 = "E92 # WK XTRA JOB2+(W-U)"
   V21278 = "E93 AV HR/WK X JB2+(W-U)"
   V21279 = "E94 MO BEG XJOB2   (W-U)"
   V21280 = "E94 YR BEG XJOB2   (W-U)"
   V21281 = "E95 WRK XJOB2 JAN91  W-U"
   V21282 = "E95 WRK XJOB2 FEB91  W-U"
   V21283 = "E95 WRK XJOB2 MAR91  W-U"
   V21284 = "E95 WRK XJOB2 APR91  W-U"
   V21285 = "E95 WRK XJOB2 MAY91  W-U"
   V21286 = "E95 WRK XJOB2 JUN91  W-U"
   V21287 = "E95 WRK XJOB2 JUL91  W-U"
   V21288 = "E95 WRK XJOB2 AUG91  W-U"
   V21289 = "E95 WRK XJOB2 SEP91  W-U"
   V21290 = "E95 WRK XJOB2 OCT91  W-U"
   V21291 = "E95 WRK XJOB2 NOV91  W-U"
   V21292 = "E95 WRK XJOB2 DEC91  W-U"
   V21293 = "E96 STOP WORK XJOB2 W-U"
   V21294 = "E97 MO END JOB2   (WF-U)"
   V21295 = "E97 YR END JOB2   (WF-U)"
   V21296 = "F1 CKPT:TYPE HEAD+WIFE"
   V21297 = "F2 HOUSEWORK HRS-WIFE"
   V21298 = "F3 HOUSEWORK HOURS-HEAD"
   V21299 = "F5 FAM TOGETHR MAIN MEAL"
   V21300 = "F7 COST CHILD CARE 1991"
   V21301 = "G2 WHETHER HEAD FARMER"
   V21302 = "G3 TOTAL FARM RECEIPTS"
   V21303 = "G6 WHETHER BUSINESS"
   V21304 = "G7 TYPE BUS HAVE INT IN"
   V21305 = "G8 WHO IN FAM OWNED BUS"
   V21306 = "G9 R PUT TIME IN BUS 91?"
   V21307 = "G10 CORP/UNINCORP BUS"
   V21308 = "G99 WTR LUMP SUM PAYMNTS"
   V21309 = "G100 LUMP SUM PAYMNTS"
   V21310 = "G101 INHERITANCE"
   V21311 = "G102 WTR ITEM 91 TAX DED"
   V21312 = "G103 WTR HELP OTRS"
   V21313 = "G104 # OTRS SUPPORTED"
   V21314 = "G105 WHO SUPPORT 1"
   V21315 = "G105 WHO SUPPORT 2"
   V21316 = "G105 WHO SUPPORT 3"
   V21317 = "G107 ANY CHILD SUPPORT"
   V21318 = "G109 ANY ALIMONY"
   V21319 = "G112-114 WTR DEPNDT OTRS"
   V21320 = "G113 # OTR DEPENDENTS"
   V21321 = "H1 STATUS OF HEALTH-HEAD"
   V21322 = "H2 LIMIT TYPE/AMT WRK  H"
   V21323 = "H3 NOT DO CERTAIN WRK  H"
   V21324 = "H4 LIMIT AMT WRK DO    H"
   V21325 = "H5 WTR AGE 55+ - HD"
   V21326 = "H25 ANY REC MED AID? 92"
   V21327 = "H27 IWCKPT-W/'W' IN FU?"
   V21328 = "H28 STATUS OF HLTH-WIFE"
   V21329 = "H29 LIMIT TYPE/AMT WRK-W"
   V21330 = "H30 NOT DO CERTAIN WRK-W"
   V21331 = "H31 LIMIT AMT WORK DO  W"
   V21332 = "H32 WTR AGE 55+ - WF"
   V21333 = "H52 WTR OFUMS < AGE 55"
   V21334 = "H53 ANY <55 OTR BAD HLTH"
   V21335 = "H55 WTR OFUMS AGE 55+"
   V21336 = "H55 # 55+ OTR IN FU"
   V21337 = "H78 WTR MOVERSOUT AGE55+"
   V21338 = "H78 # 55+ OTR MOVED OUT"
   V21339 = "L1 CKPT: WTR NEW W/'W'"
   V21340 = "L2-3 EDUC OF FATHER   WF"
   V21341 = "L4-5 EDUC OF MOTHER   WF"
   V21342 = "L6 WHETHER BROTHERS   WF"
   V21343 = "L7 # BROTHERS       WIFE"
   V21344 = "L8 ONLY BRO STILL ALIVE"
   V21345 = "L9 ONLY BRO OLDR THAN W"
   V21346 = "L10 # BRO STILL ALIVE"
   V21347 = "L11 ANY BRO OLDR THAN WF"
   V21348 = "L12 WHETHER SISTERS   WF"
   V21349 = "L13 # SISTERS       WIFE"
   V21350 = "L14 ONLY SIS STILL ALIVE"
   V21351 = "L15 ONLY SIS OLDR THAN W"
   V21352 = "L16 # SIS STILL ALIVE"
   V21353 = "L17 ANY SIS OLDR THAN WF"
   V21354 = "L18 SPANISH DESCENT   WF"
   V21355 = "L19 RACE OF WIFE 1"
   V21356 = "L19 RACE OF WIFE 2"
   V21357 = "L20 WTR IN MILIT SERV  W"
   V21358 = "L21 WTR GRADUATED HS  WF"
   V21359 = "L22 YR GRADUATED HS   WF"
   V21360 = "L23 GRADE LEVEL IF GED W"
   V21361 = "L24 YR LAST IN SCH-GED W"
   V21362 = "L25 YR RECEIVED GED   WF"
   V21363 = "L26 GRD OF SCH FINISH  W"
   V21364 = "L27 YR LAST IN SCH-NONGR"
   V21365 = "L28 WTR ATTEND COLLEGE W"
   V21366 = "L29 YR LAST ATTEND COLL"
   V21367 = "L30 HGHST YR COLL COMP W"
   V21368 = "L31 WTR RECD COLL DEG  W"
   V21369 = "L32 HGHST COLL DEG REC W"
   V21370 = "L35 YR RECD COLL DEG   W"
   V21371 = "L36 WTR REC OTR DEG/CERT"
   V21372 = "L36 # OTR DEG/CERT REC"
   V21373 = "L37 TYPE OTR DEG/CERT 1"
   V21374 = "L38 FIELD OF DEG/CERT 1"
   V21375 = "L39 INST/ORG DEG/CERT 1"
   V21376 = "L40 YR REC DEG/CERT 1"
   V21377 = "L37 TYPE OTR DEG/CERT 2"
   V21378 = "L38 FIELD OF DEG/CERT 2"
   V21379 = "L39 INST/ORG DEG/CERT 2"
   V21380 = "L40 YR REC DEG/CERT 2"
   V21381 = "L37 TYPE OTR DEG/CERT 3"
   V21382 = "L38 FIELD OF DEG/CERT 3"
   V21383 = "L39 INST/ORG DEG/CERT 3"
   V21384 = "L40 YR REC DEG/CERT 3"
   V21385 = "L42-43 RELIGIOUS PREF  W"
   V21386 = "L44 #YRS WRKD SINCE 18 W"
   V21387 = "L45 #YR WRKD FULL-TIME W"
   V21388 = "M1 CKPT: WTR NEW HEAD"
   V21389 = "M2 STATE FA GREW UP   HD"
   V21390 = "M2 CNTY FA GREW UP    HD"
   V21391 = "M3 STATE MO GREW UP   HD"
   V21392 = "M3 CNTY MO GREW UP    HD"
   V21393 = "M4 OCCUPATION OF FA   HD"
   V21394 = "M5 FIRST OCCUPATION   HD"
   V21395 = "M6 # DIFF JOBS OR?    HD"
   V21396 = "M7 GREW UP FARM OR?   HD"
   V21397 = "M8-9 STATE GREW UP    HD"
   V21398 = "M8-9 CNTY GREW UP     HD"
   V21399 = "M8-10 #REGIONS LIVED  HD"
   V21400 = "M8-10 #STATES LIVED   HD"
   V21401 = "M11 EVER MOVE FOR JOB? H"
   V21402 = "M12 NOT MOVED FOR JOB? H"
   V21403 = "M13 PARENTS POOR OR?  HD"
   V21404 = "M14-15 EDUC OF FATHER  H"
   V21405 = "M16-17 EDUC OF MOTHER  H"
   V21406 = "M18 WHETHER BROTHERS  HD"
   V21407 = "M19 # BROTHERS      HEAD"
   V21408 = "M20 ONLY BRO STILL ALIVE"
   V21409 = "M21 ONLY BRO OLDR THAN H"
   V21410 = "M22 # BRO STILL ALIVE"
   V21411 = "M23 ANY BRO OLDR THAN H"
   V21412 = "M24 WHETHER SISTERS   HD"
   V21413 = "M25 # SISTERS       HEAD"
   V21414 = "M26 ONLY SIS STILL ALIVE"
   V21415 = "M27 ONLY SIS OLDR THAN H"
   V21416 = "M28 # SIS STILL ALIVE"
   V21417 = "M29 ANY SIS OLDR THAN H"
   V21418 = "M30 LIVE W BOTH PARENT H"
   V21419 = "M31 SPANISH DESCENT   HD"
   V21420 = "M32 RACE OF HEAD 1"
   V21421 = "M32 RACE OF HEAD 2"
   V21422 = "M33 WTR IN MILIT SERV  H"
   V21423 = "M34 WTR GRADUATED HS  HD"
   V21424 = "M35 MO GRADUATED HS   HD"
   V21425 = "M35 YR GRADUATED HS   HD"
   V21426 = "M36 GRADE LEVEL IF GED H"
   V21427 = "M37 MO LAST IN SCH-GED H"
   V21428 = "M37 YR LAST IN SCH-GED H"
   V21429 = "M38 MO RECEIVED GED   HD"
   V21430 = "M38 YR RECEIVED GED   HD"
   V21431 = "M39 GRD OF SCH FINISH  H"
   V21432 = "M40 MO LAST IN SCH-NONGR"
   V21433 = "M40 YR LAST IN SCH-NONGR"
   V21434 = "M41 WTR ATTEND COLLEGE H"
   V21435 = "M42 MO LAST ATTND COLL H"
   V21436 = "M42 YR LAST ATTND COLL H"
   V21437 = "M43 HGHST YR COLL COMP H"
   V21438 = "M44 WTR RECD COLL DEG  H"
   V21439 = "M45 HGHST COLL DEG REC H"
   V21440 = "M48 MO RECD COLL DEG  HD"
   V21441 = "M48 YR RECD COLL DEG  HD"
   V21442 = "M49 WTR REC OTR DEG/CERT"
   V21443 = "M49 # OTR DEG/CERT REC"
   V21444 = "M50 TYPE OTR DEG/CERT 1"
   V21445 = "M51 FIELD OF DEG/CERT 1"
   V21446 = "M52 INST/ORG DEG/CERT 1"
   V21447 = "M53 MO REC DEG/CERT 1"
   V21448 = "M53 YR REC DEG/CERT 1"
   V21449 = "M50 TYPE OTR DEG/CERT 2"
   V21450 = "M51 FIELD OF DEG/CERT 2"
   V21451 = "M52 INST/ORG DEG/CERT 2"
   V21452 = "M53 MO REC DEG/CERT 2"
   V21453 = "M53 YR REC DEG/CERT 2"
   V21454 = "M50 TYPE OTR DEG/CERT 3"
   V21455 = "M51 FIELD OF DEG/CERT 3"
   V21456 = "M52 INST/ORG DEG/CERT 3"
   V21457 = "M53 MO REC DEG/CERT 3"
   V21458 = "M53 YR REC DEG/CERT 3"
   V21459 = "M55-56 RELIGIOUS PREF  H"
   V21460 = "M57 #YRS WRKD SINCE 18 H"
   V21461 = "M58 #YR WRKD FULL-TIME H"
   V21462 = "FS7 WHO WAS RESPONDENT"
   V21463 = "FS8 # OF INTERVWR CALLS"
   V21464 = "LANGUAGE OF IW ENGLISH?"
   V21465 = "LANGUAGE OF IW SPANISH?"
   V21466 = "LANGUAGE OF IW OTHER"
   V21467 = "# OF INDIVIDUAL RECORDS"
   V21468 = "DUMMY VARIABLE 1"
   V21469 = "DUMMY VARIABLE 2"
   V21470 = "DUMMY VARIABLE 3"
   V21471 = "DUMMY VARIABLE 4"
   V21472 = "DUMMY VARIABLE 5"
   V21473 = "DUMMY VARIABLE 6"
   V21474 = "DUMMY VARIABLE 7"
   V21475 = "DUMMY VARIABLE 8"
   V21476 = "DUMMY VARIABLE 9"
   V21477 = "DUMMY VARIABLE 10"
   V21478 = "DUMMY VARIABLE 11"
   V21479 = "DUMMY VARIABLE 12"
   V21480 = "DUMMY VARIABLE 13"
   V21481 = "TOT FAM MONEY Y 91"
   V21482 = "%  TOT FAM MNY Y 91 ACC>1"
   V21483 = "%  TOT FAM MNY Y 91 ACC>0"
   V21484 = "TOTAL HEAD LABOR Y 91"
   V21485 = "%  TOT HD LAB Y 91 ACC>1"
   V21486 = "%  TOT HD LAB Y 91 ACC>0"
   V21487 = "WEEKLY FOOD NEEDS-1992"
   V21488 = "ANNUAL NEEDS STD-1991"
   V21489 = "1991 TOT FAM Y/NEEDS"
   V21490 = "ANNUAL NEEDS STD-CENSUS"
   V21491 = "TOT FAM Y/NEEDS-CENSUS"
   V21492 = "ANNUAL FOOD STD"
   V21493 = "HEAD 91 AVG HRLY EARNING"
   V21494 = "WIFE 91 AVG HRLY EARNING"
   V21495 = "REGION OF 1992 INTERVIEW"
   V21496 = "STATE CODE (FIPS)"
   V21497 = "COUNTY CODE (FIPS)"
   V21498 = "RURAL-URBAN CODE (BEALE)"
   V21499 = "REGION 92 HD GREW UP"
   V21500 = "HEAD GEOGRAPHIC MOBILITY"
   V21501 = "ACC 91 Y COMPONENTS"
   V21502 = "# MINOR ASSGMTS IN 92"
   V21503 = "# MAJOR ASSGMTS IN 92"
   V21504 = "COMPLETED ED-HD 92"
   V21505 = "COMPLETED ED-WF 92"
   V21506 = "DECILE: 91 TOT FAM Y"
   V21507 = "# CHILDREN AGE 1-2"
   V21508 = "# CHILDREN AGE 3-5"
   V21509 = "# CHILDREN AGE 6-13"
   V21510 = "# FEM CHILDREN AGE 14-17"
   V21511 = "# MALE CHILDREN 14-17"
   V21512 = "# FEM CHILDREN 18-20"
   V21513 = "# MALE CHILDREN 18-20"
   V21514 = "# FEM CHILDREN 21-29"
   V21515 = "# MALE CHILDREN 21-29"
   V21516 = "# INDS IN ARMED FORCES"
   V21517 = "# INDS INCARCERATED"
   V21518 = "# INDS IN HLTH CARE FACL"
   V21519 = "# INDS IN EDUCATNL FACIL"
   V21520 = "SPLIT SAMPLE FILTER"
   V21521 = "CNTY UNEMP RATE-CENSUS"
   V21522 = "MARITAL STATUS 1992"
   V21523 = "91-92 CNG MARITAL STATUS"
   V21524 = "COUPLE STATUS OF HEAD"
   V21525 = "YR NEW HEAD IN FU"
   V21526 = "YR NEW WIFE IN FU"
   V21527 = "HD-SPOUSE SAMPLE STATUS"
   V21528 = "# 92 S/O FROM THIS FAM"
   V21529 = "92 MAIN FAM ID FOR S/0"
   V21530 = "92ID OF 1ST OTR FU IN HU"
   V21531 = "REL OF 1ST OTHER FU"
   V21532 = "SIZE OF 1ST OTHER FU"
   V21533 = "92ID OF 2ND OTR FU IN HU"
   V21534 = "REL OF 2ND OTHER FU"
   V21535 = "SIZE OF 2ND OTHER FU"
   V21536 = "92ID OF 3RD OTR FU IN HU"
   V21537 = "REL OF 3RD OTHER FU"
   V21538 = "SIZE OF 3RD OTHER FU"
   V21539 = "92ID OF 4TH OTR FU IN HU"
   V21540 = "REL OF 4TH OTHER FU"
   V21541 = "SIZE OF 4TH OTHER FU"
   V21542 = "HOUSEHOLD ID #"
   V21543 = "# BORN TO HD ONLY IN 91"
   V21544 = "#BORN TO W/'W' ONLY IN91"
   V21545 = "#BRN TO H+W JOINTLY IN91"
   V21546 = "# BORN TO OFUMS IN 91"
   V21547 = "1992 CORE FAMILY WEIGHT"
   V21548 = "1992 LATINO FAM WEIGHT"
   V21549 = "1992 COMBINED FAM WEIGHT";

* USER-DEFINED MISSING VALUE RECODE TO SAS SYSMIS;

IF V20303=99 THEN V20303=.;
IF V20304=999 THEN V20304=.;
IF V20305=99999 THEN V20305=.;
IF V20306=9 THEN V20306=.;
IF V20308=9 THEN V20308=.;
IF V20309=9 THEN V20309=.;
IF V20310=9 THEN V20310=.;
IF V20317=9999 THEN V20317=.;
IF V20318=999 THEN V20318=.;
IF V20319=99 THEN V20319=.;
IF V20320=9 THEN V20320=.;
IF V20321=99 THEN V20321=.;
IF V20332=9999 THEN V20332=.;
IF V20337=9999 THEN V20337=.;
IF V20355=9 THEN V20355=.;
IF V20356=9 THEN V20356=.;
IF V20357=9 THEN V20357=.;
IF V20358=9 THEN V20358=.;
IF V20359=9 THEN V20359=.;
IF V20360=9 THEN V20360=.;
IF V20361=9 THEN V20361=.;
IF V20362=9 THEN V20362=.;
IF V20363=9 THEN V20363=.;
IF V20364=9 THEN V20364=.;
IF V20365=9 THEN V20365=.;
IF V20366=9 THEN V20366=.;
IF V20385=9 THEN V20385=.;
IF V20386=9 THEN V20386=.;
IF V20387=9 THEN V20387=.;
IF V20388=9 THEN V20388=.;
IF V20389=9 THEN V20389=.;
IF V20390=9 THEN V20390=.;
IF V20391=9 THEN V20391=.;
IF V20392=9 THEN V20392=.;
IF V20393=9 THEN V20393=.;
IF V20394=9 THEN V20394=.;
IF V20395=9 THEN V20395=.;
IF V20396=9 THEN V20396=.;
IF V20404=9 THEN V20404=.;
IF V20413=99 THEN V20413=.;
IF V20414=9 THEN V20414=.;
IF V20415=9 THEN V20415=.;
IF V20416=9 THEN V20416=.;
IF V20417=9 THEN V20417=.;
IF V20418=9 THEN V20418=.;
IF V20419=9 THEN V20419=.;
IF V20420=9 THEN V20420=.;
IF V20421=9 THEN V20421=.;
IF V20422=9 THEN V20422=.;
IF V20423=9 THEN V20423=.;
IF V20424=9 THEN V20424=.;
IF V20425=9 THEN V20425=.;
IF V20443=99 THEN V20443=.;
IF V20445=99 THEN V20445=.;
IF V20447=99 THEN V20447=.;
IF V20452=99999 THEN V20452=.;
IF V20453=99999 THEN V20453=.;
IF V20454=99999 THEN V20454=.;
IF V20461=99 THEN V20461=.;
IF V20464=99 THEN V20464=.;
IF V20466=9 THEN V20466=.;
IF V20467=99 THEN V20467=.;
IF V20469=99 THEN V20469=.;
IF V20471=9 THEN V20471=.;
IF V20474=99 THEN V20474=.;
IF V20476=99 THEN V20476=.;
IF V20478=99 THEN V20478=.;
IF V20482=99 THEN V20482=.;
IF V20485=99 THEN V20485=.;
IF V20487=9 THEN V20487=.;
IF V20488=99 THEN V20488=.;
IF V20490=99 THEN V20490=.;
IF V20494=99 THEN V20494=.;
IF V20496=99 THEN V20496=.;
IF V20498=99 THEN V20498=.;
IF V20502=9 THEN V20502=.;
IF V20503=9 THEN V20503=.;
IF V20504=9 THEN V20504=.;
IF V20505=9 THEN V20505=.;
IF V20506=9 THEN V20506=.;
IF V20507=9 THEN V20507=.;
IF V20508=9 THEN V20508=.;
IF V20509=9 THEN V20509=.;
IF V20510=9 THEN V20510=.;
IF V20511=9 THEN V20511=.;
IF V20512=9 THEN V20512=.;
IF V20513=9 THEN V20513=.;
IF V20514=9 THEN V20514=.;
IF V20515=9 THEN V20515=.;
IF V20516=9 THEN V20516=.;
IF V20517=9 THEN V20517=.;
IF V20518=9 THEN V20518=.;
IF V20519=9 THEN V20519=.;
IF V20520=9 THEN V20520=.;
IF V20521=9 THEN V20521=.;
IF V20522=9 THEN V20522=.;
IF V20523=9 THEN V20523=.;
IF V20524=9 THEN V20524=.;
IF V20525=9 THEN V20525=.;
IF V20526=9 THEN V20526=.;
IF V20527=9 THEN V20527=.;
IF V20528=9 THEN V20528=.;
IF V20529=9 THEN V20529=.;
IF V20530=9 THEN V20530=.;
IF V20531=9 THEN V20531=.;
IF V20532=9 THEN V20532=.;
IF V20533=9 THEN V20533=.;
IF V20534=9 THEN V20534=.;
IF V20535=9 THEN V20535=.;
IF V20536=9 THEN V20536=.;
IF V20537=9 THEN V20537=.;
IF V20538=9 THEN V20538=.;
IF V20539=9 THEN V20539=.;
IF V20540=9 THEN V20540=.;
IF V20541=9 THEN V20541=.;
IF V20542=9 THEN V20542=.;
IF V20543=9 THEN V20543=.;
IF V20544=9 THEN V20544=.;
IF V20545=9 THEN V20545=.;
IF V20546=9 THEN V20546=.;
IF V20547=9 THEN V20547=.;
IF V20548=9 THEN V20548=.;
IF V20549=9 THEN V20549=.;
IF V20550=9 THEN V20550=.;
IF V20551=9 THEN V20551=.;
IF V20552=9 THEN V20552=.;
IF V20553=9 THEN V20553=.;
IF V20554=9 THEN V20554=.;
IF V20555=9 THEN V20555=.;
IF V20556=9 THEN V20556=.;
IF V20557=9 THEN V20557=.;
IF V20558=9 THEN V20558=.;
IF V20559=9 THEN V20559=.;
IF V20560=9 THEN V20560=.;
IF V20561=9 THEN V20561=.;
IF V20562=9 THEN V20562=.;
IF V20563=9 THEN V20563=.;
IF V20564=9 THEN V20564=.;
IF V20565=9 THEN V20565=.;
IF V20566=9 THEN V20566=.;
IF V20567=9 THEN V20567=.;
IF V20568=9 THEN V20568=.;
IF V20569=9 THEN V20569=.;
IF V20570=9 THEN V20570=.;
IF V20571=9 THEN V20571=.;
IF V20572=9 THEN V20572=.;
IF V20573=9 THEN V20573=.;
IF V20646=9999 THEN V20646=.;
IF V20647=999 THEN V20647=.;
IF V20648=9999 THEN V20648=.;
IF V20649=999 THEN V20649=.;
IF V20651=99 THEN V20651=.;
IF V20653=99 THEN V20653=.;
IF V20655=99 THEN V20655=.;
IF V20656=99 THEN V20656=.;
IF V20657=9 THEN V20657=.;
IF V20658=9 THEN V20658=.;
IF V20659=9 THEN V20659=.;
IF V20660=9 THEN V20660=.;
IF V20661=9 THEN V20661=.;
IF V20662=9 THEN V20662=.;
IF V20663=9 THEN V20663=.;
IF V20664=9 THEN V20664=.;
IF V20665=9 THEN V20665=.;
IF V20666=9 THEN V20666=.;
IF V20667=9 THEN V20667=.;
IF V20668=99 THEN V20668=.;
IF V20670=99 THEN V20670=.;
IF V20671=9 THEN V20671=.;
IF V20673=9 THEN V20673=.;
IF V20674=99 THEN V20674=.;
IF V20675=9 THEN V20675=.;
IF V20676=9 THEN V20676=.;
IF V20677=9 THEN V20677=.;
IF V20678=9 THEN V20678=.;
IF V20679=9 THEN V20679=.;
IF V20680=9 THEN V20680=.;
IF V20681=9 THEN V20681=.;
IF V20682=9 THEN V20682=.;
IF V20683=9 THEN V20683=.;
IF V20684=9 THEN V20684=.;
IF V20685=9 THEN V20685=.;
IF V20686=9 THEN V20686=.;
IF V20687=9 THEN V20687=.;
IF V20688=99 THEN V20688=.;
IF V20689=9 THEN V20689=.;
IF V20690=9 THEN V20690=.;
IF V20691=9 THEN V20691=.;
IF V20692=9 THEN V20692=.;
IF V20694=99 THEN V20694=.;
IF V20695=9 THEN V20695=.;
IF V20696=9 THEN V20696=.;
IF V20697=9 THEN V20697=.;
IF V20698=9 THEN V20698=.;
IF V20699=9 THEN V20699=.;
IF V20700=9 THEN V20700=.;
IF V20701=999 THEN V20701=.;
IF V20702=999 THEN V20702=.;
IF V20703=9 THEN V20703=.;
IF V20704=9999 THEN V20704=.;
IF V20705=9 THEN V20705=.;
IF V20706=9999 THEN V20706=.;
IF V20707=9999 THEN V20707=.;
IF V20708=9999 THEN V20708=.;
IF V20709=9 THEN V20709=.;
IF V20710=9999 THEN V20710=.;
IF V20711=9 THEN V20711=.;
IF V20712=9 THEN V20712=.;
IF V20713=9 THEN V20713=.;
IF V20714=9 THEN V20714=.;
IF V20715=9 THEN V20715=.;
IF V20716=9 THEN V20716=.;
IF V20717=9 THEN V20717=.;
IF V20718=9 THEN V20718=.;
IF V20719=9 THEN V20719=.;
IF V20720=999 THEN V20720=.;
IF V20721=99 THEN V20721=.;
IF V20722=99 THEN V20722=.;
IF V20723=9 THEN V20723=.;
IF V20724=99 THEN V20724=.;
IF V20725=99 THEN V20725=.;
IF V20726=9 THEN V20726=.;
IF V20727=99 THEN V20727=.;
IF V20728=9 THEN V20728=.;
IF V20729=99 THEN V20729=.;
IF V20730=99 THEN V20730=.;
IF V20731=99 THEN V20731=.;
IF V20732=99 THEN V20732=.;
IF V20733=9 THEN V20733=.;
IF V20734=99 THEN V20734=.;
IF V20735=9 THEN V20735=.;
IF V20736=999 THEN V20736=.;
IF V20737=9999 THEN V20737=.;
IF V20738=99 THEN V20738=.;
IF V20739=9 THEN V20739=.;
IF V20740=9 THEN V20740=.;
IF V20741=9 THEN V20741=.;
IF V20742=9 THEN V20742=.;
IF V20743=9 THEN V20743=.;
IF V20744=9 THEN V20744=.;
IF V20745=9 THEN V20745=.;
IF V20746=9 THEN V20746=.;
IF V20747=9 THEN V20747=.;
IF V20748=9 THEN V20748=.;
IF V20749=9 THEN V20749=.;
IF V20750=9 THEN V20750=.;
IF V20751=9 THEN V20751=.;
IF V20752=99 THEN V20752=.;
IF V20753=99 THEN V20753=.;
IF V20754=9 THEN V20754=.;
IF V20755=9 THEN V20755=.;
IF V20756=9 THEN V20756=.;
IF V20757=9 THEN V20757=.;
IF V20758=9 THEN V20758=.;
IF V20759=9 THEN V20759=.;
IF V20760=9 THEN V20760=.;
IF V20761=9 THEN V20761=.;
IF V20762=9 THEN V20762=.;
IF V20763=9 THEN V20763=.;
IF V20764=9 THEN V20764=.;
IF V20765=9 THEN V20765=.;
IF V20766=9 THEN V20766=.;
IF V20767=9 THEN V20767=.;
IF V20768=9 THEN V20768=.;
IF V20769=999 THEN V20769=.;
IF V20770=999 THEN V20770=.;
IF V20771=9999 THEN V20771=.;
IF V20772=99 THEN V20772=.;
IF V20773=9 THEN V20773=.;
IF V20774=99 THEN V20774=.;
IF V20775=9 THEN V20775=.;
IF V20776=9 THEN V20776=.;
IF V20777=99 THEN V20777=.;
IF V20778=99 THEN V20778=.;
IF V20779=9 THEN V20779=.;
IF V20780=9999 THEN V20780=.;
IF V20781=99 THEN V20781=.;
IF V20782=9 THEN V20782=.;
IF V20784=9 THEN V20784=.;
IF V20785=99 THEN V20785=.;
IF V20786=9 THEN V20786=.;
IF V20787=99 THEN V20787=.;
IF V20788=9 THEN V20788=.;
IF V20789=99 THEN V20789=.;
IF V20790=9 THEN V20790=.;
IF V20791=99 THEN V20791=.;
IF V20792=9 THEN V20792=.;
IF V20793=99 THEN V20793=.;
IF V20794=9 THEN V20794=.;
IF V20795=99 THEN V20795=.;
IF V20796=99 THEN V20796=.;
IF V20797=99 THEN V20797=.;
IF V20798=9 THEN V20798=.;
IF V20799=9 THEN V20799=.;
IF V20800=9 THEN V20800=.;
IF V20801=9 THEN V20801=.;
IF V20802=999 THEN V20802=.;
IF V20803=999 THEN V20803=.;
IF V20804=9999 THEN V20804=.;
IF V20805=99 THEN V20805=.;
IF V20806=99 THEN V20806=.;
IF V20807=99 THEN V20807=.;
IF V20808=99 THEN V20808=.;
IF V20809=9 THEN V20809=.;
IF V20810=9 THEN V20810=.;
IF V20811=9 THEN V20811=.;
IF V20812=9 THEN V20812=.;
IF V20813=9 THEN V20813=.;
IF V20814=9 THEN V20814=.;
IF V20815=9 THEN V20815=.;
IF V20816=9 THEN V20816=.;
IF V20817=9 THEN V20817=.;
IF V20818=9 THEN V20818=.;
IF V20819=9 THEN V20819=.;
IF V20820=9 THEN V20820=.;
IF V20821=9 THEN V20821=.;
IF V20822=99 THEN V20822=.;
IF V20823=99 THEN V20823=.;
IF V20824=9 THEN V20824=.;
IF V20825=999 THEN V20825=.;
IF V20826=999 THEN V20826=.;
IF V20827=9999 THEN V20827=.;
IF V20828=99 THEN V20828=.;
IF V20829=99 THEN V20829=.;
IF V20830=99 THEN V20830=.;
IF V20831=99 THEN V20831=.;
IF V20832=9 THEN V20832=.;
IF V20833=9 THEN V20833=.;
IF V20834=9 THEN V20834=.;
IF V20835=9 THEN V20835=.;
IF V20836=9 THEN V20836=.;
IF V20837=9 THEN V20837=.;
IF V20838=9 THEN V20838=.;
IF V20839=9 THEN V20839=.;
IF V20840=9 THEN V20840=.;
IF V20841=9 THEN V20841=.;
IF V20842=9 THEN V20842=.;
IF V20843=9 THEN V20843=.;
IF V20844=9 THEN V20844=.;
IF V20845=99 THEN V20845=.;
IF V20846=99 THEN V20846=.;
IF V20847=9 THEN V20847=.;
IF V20848=9 THEN V20848=.;
IF V20849=9 THEN V20849=.;
IF V20850=9 THEN V20850=.;
IF V20851=9 THEN V20851=.;
IF V20852=9 THEN V20852=.;
IF V20853=9 THEN V20853=.;
IF V20854=9 THEN V20854=.;
IF V20855=9 THEN V20855=.;
IF V20856=99 THEN V20856=.;
IF V20857=9 THEN V20857=.;
IF V20858=99 THEN V20858=.;
IF V20859=99 THEN V20859=.;
IF V20860=9 THEN V20860=.;
IF V20861=99 THEN V20861=.;
IF V20862=999 THEN V20862=.;
IF V20863=999 THEN V20863=.;
IF V20864=9 THEN V20864=.;
IF V20865=9 THEN V20865=.;
IF V20866=9 THEN V20866=.;
IF V20867=9 THEN V20867=.;
IF V20868=99 THEN V20868=.;
IF V20869=99 THEN V20869=.;
IF V20870=9 THEN V20870=.;
IF V20871=99 THEN V20871=.;
IF V20872=99 THEN V20872=.;
IF V20873=9 THEN V20873=.;
IF V20874=99 THEN V20874=.;
IF V20875=9 THEN V20875=.;
IF V20876=99 THEN V20876=.;
IF V20877=99 THEN V20877=.;
IF V20878=99 THEN V20878=.;
IF V20879=99 THEN V20879=.;
IF V20880=9 THEN V20880=.;
IF V20881=99 THEN V20881=.;
IF V20882=9 THEN V20882=.;
IF V20883=999 THEN V20883=.;
IF V20884=9999 THEN V20884=.;
IF V20885=99 THEN V20885=.;
IF V20886=9 THEN V20886=.;
IF V20887=9 THEN V20887=.;
IF V20888=9 THEN V20888=.;
IF V20889=9 THEN V20889=.;
IF V20890=9 THEN V20890=.;
IF V20891=9 THEN V20891=.;
IF V20892=9 THEN V20892=.;
IF V20893=9 THEN V20893=.;
IF V20894=9 THEN V20894=.;
IF V20895=9 THEN V20895=.;
IF V20896=9 THEN V20896=.;
IF V20897=9 THEN V20897=.;
IF V20898=9 THEN V20898=.;
IF V20899=99 THEN V20899=.;
IF V20900=99 THEN V20900=.;
IF V20901=9 THEN V20901=.;
IF V20902=9 THEN V20902=.;
IF V20903=9 THEN V20903=.;
IF V20904=9 THEN V20904=.;
IF V20905=9 THEN V20905=.;
IF V20906=9 THEN V20906=.;
IF V20907=9 THEN V20907=.;
IF V20908=9 THEN V20908=.;
IF V20909=9 THEN V20909=.;
IF V20910=9 THEN V20910=.;
IF V20911=9 THEN V20911=.;
IF V20912=9 THEN V20912=.;
IF V20913=9 THEN V20913=.;
IF V20914=9 THEN V20914=.;
IF V20915=9 THEN V20915=.;
IF V20916=999 THEN V20916=.;
IF V20917=999 THEN V20917=.;
IF V20918=9999 THEN V20918=.;
IF V20919=99 THEN V20919=.;
IF V20920=9 THEN V20920=.;
IF V20921=99 THEN V20921=.;
IF V20922=9 THEN V20922=.;
IF V20923=9 THEN V20923=.;
IF V20924=99 THEN V20924=.;
IF V20925=99 THEN V20925=.;
IF V20926=9 THEN V20926=.;
IF V20927=9999 THEN V20927=.;
IF V20928=99 THEN V20928=.;
IF V20929=9 THEN V20929=.;
IF V20931=9 THEN V20931=.;
IF V20932=99 THEN V20932=.;
IF V20933=9 THEN V20933=.;
IF V20934=99 THEN V20934=.;
IF V20935=9 THEN V20935=.;
IF V20936=99 THEN V20936=.;
IF V20937=9 THEN V20937=.;
IF V20938=99 THEN V20938=.;
IF V20939=9 THEN V20939=.;
IF V20940=99 THEN V20940=.;
IF V20941=9 THEN V20941=.;
IF V20942=99 THEN V20942=.;
IF V20943=99 THEN V20943=.;
IF V20944=99 THEN V20944=.;
IF V20945=9 THEN V20945=.;
IF V20946=9 THEN V20946=.;
IF V20947=9 THEN V20947=.;
IF V20948=9 THEN V20948=.;
IF V20949=999 THEN V20949=.;
IF V20950=999 THEN V20950=.;
IF V20951=9999 THEN V20951=.;
IF V20952=99 THEN V20952=.;
IF V20953=99 THEN V20953=.;
IF V20954=99 THEN V20954=.;
IF V20955=99 THEN V20955=.;
IF V20956=9 THEN V20956=.;
IF V20957=9 THEN V20957=.;
IF V20958=9 THEN V20958=.;
IF V20959=9 THEN V20959=.;
IF V20960=9 THEN V20960=.;
IF V20961=9 THEN V20961=.;
IF V20962=9 THEN V20962=.;
IF V20963=9 THEN V20963=.;
IF V20964=9 THEN V20964=.;
IF V20965=9 THEN V20965=.;
IF V20966=9 THEN V20966=.;
IF V20967=9 THEN V20967=.;
IF V20968=9 THEN V20968=.;
IF V20969=99 THEN V20969=.;
IF V20970=99 THEN V20970=.;
IF V20971=9 THEN V20971=.;
IF V20972=999 THEN V20972=.;
IF V20973=999 THEN V20973=.;
IF V20974=9999 THEN V20974=.;
IF V20975=99 THEN V20975=.;
IF V20976=99 THEN V20976=.;
IF V20977=99 THEN V20977=.;
IF V20978=99 THEN V20978=.;
IF V20979=9 THEN V20979=.;
IF V20980=9 THEN V20980=.;
IF V20981=9 THEN V20981=.;
IF V20982=9 THEN V20982=.;
IF V20983=9 THEN V20983=.;
IF V20984=9 THEN V20984=.;
IF V20985=9 THEN V20985=.;
IF V20986=9 THEN V20986=.;
IF V20987=9 THEN V20987=.;
IF V20988=9 THEN V20988=.;
IF V20989=9 THEN V20989=.;
IF V20990=9 THEN V20990=.;
IF V20991=9 THEN V20991=.;
IF V20992=99 THEN V20992=.;
IF V20993=99 THEN V20993=.;
IF V20996=99 THEN V20996=.;
IF V20997=9 THEN V20997=.;
IF V20998=9 THEN V20998=.;
IF V20999=9 THEN V20999=.;
IF V21000=9 THEN V21000=.;
IF V21001=9 THEN V21001=.;
IF V21002=9 THEN V21002=.;
IF V21003=999 THEN V21003=.;
IF V21004=999 THEN V21004=.;
IF V21005=9 THEN V21005=.;
IF V21006=9999 THEN V21006=.;
IF V21007=9 THEN V21007=.;
IF V21008=9999 THEN V21008=.;
IF V21009=9999 THEN V21009=.;
IF V21010=9999 THEN V21010=.;
IF V21011=9 THEN V21011=.;
IF V21012=9999 THEN V21012=.;
IF V21013=9 THEN V21013=.;
IF V21014=9 THEN V21014=.;
IF V21015=9 THEN V21015=.;
IF V21016=9 THEN V21016=.;
IF V21017=9 THEN V21017=.;
IF V21018=9 THEN V21018=.;
IF V21019=9 THEN V21019=.;
IF V21020=9 THEN V21020=.;
IF V21021=9 THEN V21021=.;
IF V21022=999 THEN V21022=.;
IF V21023=99 THEN V21023=.;
IF V21024=99 THEN V21024=.;
IF V21025=9 THEN V21025=.;
IF V21026=99 THEN V21026=.;
IF V21027=99 THEN V21027=.;
IF V21028=9 THEN V21028=.;
IF V21029=99 THEN V21029=.;
IF V21030=9 THEN V21030=.;
IF V21031=99 THEN V21031=.;
IF V21032=99 THEN V21032=.;
IF V21033=99 THEN V21033=.;
IF V21034=99 THEN V21034=.;
IF V21035=9 THEN V21035=.;
IF V21036=99 THEN V21036=.;
IF V21037=9 THEN V21037=.;
IF V21038=999 THEN V21038=.;
IF V21039=9999 THEN V21039=.;
IF V21040=99 THEN V21040=.;
IF V21041=9 THEN V21041=.;
IF V21042=9 THEN V21042=.;
IF V21043=9 THEN V21043=.;
IF V21044=9 THEN V21044=.;
IF V21045=9 THEN V21045=.;
IF V21046=9 THEN V21046=.;
IF V21047=9 THEN V21047=.;
IF V21048=9 THEN V21048=.;
IF V21049=9 THEN V21049=.;
IF V21050=9 THEN V21050=.;
IF V21051=9 THEN V21051=.;
IF V21052=9 THEN V21052=.;
IF V21053=9 THEN V21053=.;
IF V21054=99 THEN V21054=.;
IF V21055=99 THEN V21055=.;
IF V21056=9 THEN V21056=.;
IF V21057=9 THEN V21057=.;
IF V21058=9 THEN V21058=.;
IF V21059=9 THEN V21059=.;
IF V21060=9 THEN V21060=.;
IF V21061=9 THEN V21061=.;
IF V21062=9 THEN V21062=.;
IF V21063=9 THEN V21063=.;
IF V21064=9 THEN V21064=.;
IF V21065=9 THEN V21065=.;
IF V21066=9 THEN V21066=.;
IF V21067=9 THEN V21067=.;
IF V21068=9 THEN V21068=.;
IF V21069=9 THEN V21069=.;
IF V21070=9 THEN V21070=.;
IF V21071=999 THEN V21071=.;
IF V21072=999 THEN V21072=.;
IF V21073=9999 THEN V21073=.;
IF V21074=99 THEN V21074=.;
IF V21075=9 THEN V21075=.;
IF V21076=99 THEN V21076=.;
IF V21077=9 THEN V21077=.;
IF V21078=9 THEN V21078=.;
IF V21079=99 THEN V21079=.;
IF V21080=99 THEN V21080=.;
IF V21081=9 THEN V21081=.;
IF V21082=9999 THEN V21082=.;
IF V21083=99 THEN V21083=.;
IF V21084=9 THEN V21084=.;
IF V21086=9 THEN V21086=.;
IF V21087=99 THEN V21087=.;
IF V21088=9 THEN V21088=.;
IF V21089=99 THEN V21089=.;
IF V21090=9 THEN V21090=.;
IF V21091=99 THEN V21091=.;
IF V21092=9 THEN V21092=.;
IF V21093=99 THEN V21093=.;
IF V21094=9 THEN V21094=.;
IF V21095=99 THEN V21095=.;
IF V21096=9 THEN V21096=.;
IF V21097=99 THEN V21097=.;
IF V21098=99 THEN V21098=.;
IF V21099=99 THEN V21099=.;
IF V21100=9 THEN V21100=.;
IF V21101=9 THEN V21101=.;
IF V21102=9 THEN V21102=.;
IF V21103=9 THEN V21103=.;
IF V21104=999 THEN V21104=.;
IF V21105=999 THEN V21105=.;
IF V21106=9999 THEN V21106=.;
IF V21107=99 THEN V21107=.;
IF V21108=99 THEN V21108=.;
IF V21109=99 THEN V21109=.;
IF V21110=99 THEN V21110=.;
IF V21111=9 THEN V21111=.;
IF V21112=9 THEN V21112=.;
IF V21113=9 THEN V21113=.;
IF V21114=9 THEN V21114=.;
IF V21115=9 THEN V21115=.;
IF V21116=9 THEN V21116=.;
IF V21117=9 THEN V21117=.;
IF V21118=9 THEN V21118=.;
IF V21119=9 THEN V21119=.;
IF V21120=9 THEN V21120=.;
IF V21121=9 THEN V21121=.;
IF V21122=9 THEN V21122=.;
IF V21123=9 THEN V21123=.;
IF V21124=99 THEN V21124=.;
IF V21125=99 THEN V21125=.;
IF V21126=9 THEN V21126=.;
IF V21127=999 THEN V21127=.;
IF V21128=999 THEN V21128=.;
IF V21129=9999 THEN V21129=.;
IF V21130=99 THEN V21130=.;
IF V21131=99 THEN V21131=.;
IF V21132=99 THEN V21132=.;
IF V21133=99 THEN V21133=.;
IF V21134=9 THEN V21134=.;
IF V21135=9 THEN V21135=.;
IF V21136=9 THEN V21136=.;
IF V21137=9 THEN V21137=.;
IF V21138=9 THEN V21138=.;
IF V21139=9 THEN V21139=.;
IF V21140=9 THEN V21140=.;
IF V21141=9 THEN V21141=.;
IF V21142=9 THEN V21142=.;
IF V21143=9 THEN V21143=.;
IF V21144=9 THEN V21144=.;
IF V21145=9 THEN V21145=.;
IF V21146=9 THEN V21146=.;
IF V21147=99 THEN V21147=.;
IF V21148=99 THEN V21148=.;
IF V21149=9 THEN V21149=.;
IF V21150=9 THEN V21150=.;
IF V21151=9 THEN V21151=.;
IF V21152=9 THEN V21152=.;
IF V21153=9 THEN V21153=.;
IF V21154=9 THEN V21154=.;
IF V21155=9 THEN V21155=.;
IF V21156=9 THEN V21156=.;
IF V21157=9 THEN V21157=.;
IF V21158=99 THEN V21158=.;
IF V21159=9 THEN V21159=.;
IF V21160=99 THEN V21160=.;
IF V21161=99 THEN V21161=.;
IF V21162=9 THEN V21162=.;
IF V21163=99 THEN V21163=.;
IF V21164=999 THEN V21164=.;
IF V21165=999 THEN V21165=.;
IF V21166=9 THEN V21166=.;
IF V21167=9 THEN V21167=.;
IF V21168=9 THEN V21168=.;
IF V21169=9 THEN V21169=.;
IF V21170=99 THEN V21170=.;
IF V21171=99 THEN V21171=.;
IF V21172=9 THEN V21172=.;
IF V21173=99 THEN V21173=.;
IF V21174=99 THEN V21174=.;
IF V21175=9 THEN V21175=.;
IF V21176=99 THEN V21176=.;
IF V21177=9 THEN V21177=.;
IF V21178=99 THEN V21178=.;
IF V21179=99 THEN V21179=.;
IF V21180=99 THEN V21180=.;
IF V21181=99 THEN V21181=.;
IF V21182=9 THEN V21182=.;
IF V21183=99 THEN V21183=.;
IF V21184=9 THEN V21184=.;
IF V21185=999 THEN V21185=.;
IF V21186=9999 THEN V21186=.;
IF V21187=99 THEN V21187=.;
IF V21188=9 THEN V21188=.;
IF V21189=9 THEN V21189=.;
IF V21190=9 THEN V21190=.;
IF V21191=9 THEN V21191=.;
IF V21192=9 THEN V21192=.;
IF V21193=9 THEN V21193=.;
IF V21194=9 THEN V21194=.;
IF V21195=9 THEN V21195=.;
IF V21196=9 THEN V21196=.;
IF V21197=9 THEN V21197=.;
IF V21198=9 THEN V21198=.;
IF V21199=9 THEN V21199=.;
IF V21200=9 THEN V21200=.;
IF V21201=99 THEN V21201=.;
IF V21202=99 THEN V21202=.;
IF V21203=9 THEN V21203=.;
IF V21204=9 THEN V21204=.;
IF V21205=9 THEN V21205=.;
IF V21206=9 THEN V21206=.;
IF V21207=9 THEN V21207=.;
IF V21208=9 THEN V21208=.;
IF V21209=9 THEN V21209=.;
IF V21210=9 THEN V21210=.;
IF V21211=9 THEN V21211=.;
IF V21212=9 THEN V21212=.;
IF V21213=9 THEN V21213=.;
IF V21214=9 THEN V21214=.;
IF V21215=9 THEN V21215=.;
IF V21216=9 THEN V21216=.;
IF V21217=9 THEN V21217=.;
IF V21218=999 THEN V21218=.;
IF V21219=999 THEN V21219=.;
IF V21220=9999 THEN V21220=.;
IF V21221=99 THEN V21221=.;
IF V21222=9 THEN V21222=.;
IF V21223=99 THEN V21223=.;
IF V21224=9 THEN V21224=.;
IF V21225=9 THEN V21225=.;
IF V21226=99 THEN V21226=.;
IF V21227=99 THEN V21227=.;
IF V21228=9 THEN V21228=.;
IF V21229=9999 THEN V21229=.;
IF V21230=99 THEN V21230=.;
IF V21231=9 THEN V21231=.;
IF V21233=9 THEN V21233=.;
IF V21234=99 THEN V21234=.;
IF V21235=9 THEN V21235=.;
IF V21236=99 THEN V21236=.;
IF V21237=9 THEN V21237=.;
IF V21238=99 THEN V21238=.;
IF V21239=9 THEN V21239=.;
IF V21240=99 THEN V21240=.;
IF V21241=9 THEN V21241=.;
IF V21242=99 THEN V21242=.;
IF V21243=9 THEN V21243=.;
IF V21244=99 THEN V21244=.;
IF V21245=99 THEN V21245=.;
IF V21246=99 THEN V21246=.;
IF V21247=9 THEN V21247=.;
IF V21248=9 THEN V21248=.;
IF V21249=9 THEN V21249=.;
IF V21250=9 THEN V21250=.;
IF V21251=999 THEN V21251=.;
IF V21252=999 THEN V21252=.;
IF V21253=9999 THEN V21253=.;
IF V21254=99 THEN V21254=.;
IF V21255=99 THEN V21255=.;
IF V21256=99 THEN V21256=.;
IF V21257=99 THEN V21257=.;
IF V21258=9 THEN V21258=.;
IF V21259=9 THEN V21259=.;
IF V21260=9 THEN V21260=.;
IF V21261=9 THEN V21261=.;
IF V21262=9 THEN V21262=.;
IF V21263=9 THEN V21263=.;
IF V21264=9 THEN V21264=.;
IF V21265=9 THEN V21265=.;
IF V21266=9 THEN V21266=.;
IF V21267=9 THEN V21267=.;
IF V21268=9 THEN V21268=.;
IF V21269=9 THEN V21269=.;
IF V21270=9 THEN V21270=.;
IF V21271=99 THEN V21271=.;
IF V21272=99 THEN V21272=.;
IF V21273=9 THEN V21273=.;
IF V21274=999 THEN V21274=.;
IF V21275=999 THEN V21275=.;
IF V21276=9999 THEN V21276=.;
IF V21277=99 THEN V21277=.;
IF V21278=99 THEN V21278=.;
IF V21279=99 THEN V21279=.;
IF V21280=99 THEN V21280=.;
IF V21281=9 THEN V21281=.;
IF V21282=9 THEN V21282=.;
IF V21283=9 THEN V21283=.;
IF V21284=9 THEN V21284=.;
IF V21285=9 THEN V21285=.;
IF V21286=9 THEN V21286=.;
IF V21287=9 THEN V21287=.;
IF V21288=9 THEN V21288=.;
IF V21289=9 THEN V21289=.;
IF V21290=9 THEN V21290=.;
IF V21291=9 THEN V21291=.;
IF V21292=9 THEN V21292=.;
IF V21293=9 THEN V21293=.;
IF V21294=99 THEN V21294=.;
IF V21295=99 THEN V21295=.;
IF V21297=99 THEN V21297=.;
IF V21298=99 THEN V21298=.;
IF V21299=9 THEN V21299=.;
IF V21300=99999 THEN V21300=.;
IF V21301=9 THEN V21301=.;
IF V21302=999999 THEN V21302=.;
IF V21303=9 THEN V21303=.;
IF V21304=99 THEN V21304=.;
IF V21305=9 THEN V21305=.;
IF V21306=9 THEN V21306=.;
IF V21307=9 THEN V21307=.;
IF V21308=9 THEN V21308=.;
IF V21309=999999 THEN V21309=.;
IF V21310=999999 THEN V21310=.;
IF V21311=9 THEN V21311=.;
IF V21312=9 THEN V21312=.;
IF V21313=99 THEN V21313=.;
IF V21314=99 THEN V21314=.;
IF V21315=99 THEN V21315=.;
IF V21316=99 THEN V21316=.;
IF V21317=9 THEN V21317=.;
IF V21318=9 THEN V21318=.;
IF V21319=9 THEN V21319=.;
IF V21320=9 THEN V21320=.;
IF V21321=9 THEN V21321=.;
IF V21322=9 THEN V21322=.;
IF V21323=9 THEN V21323=.;
IF V21324=9 THEN V21324=.;
IF V21325=9 THEN V21325=.;
IF V21326=9 THEN V21326=.;
IF V21328=9 THEN V21328=.;
IF V21329=9 THEN V21329=.;
IF V21330=9 THEN V21330=.;
IF V21331=9 THEN V21331=.;
IF V21332=9 THEN V21332=.;
IF V21333=9 THEN V21333=.;
IF V21334=9 THEN V21334=.;
IF V21337=9 THEN V21337=.;
IF V21338=9 THEN V21338=.;
IF V21340=9 THEN V21340=.;
IF V21341=9 THEN V21341=.;
IF V21342=9 THEN V21342=.;
IF V21343=99 THEN V21343=.;
IF V21344=9 THEN V21344=.;
IF V21345=9 THEN V21345=.;
IF V21346=99 THEN V21346=.;
IF V21347=9 THEN V21347=.;
IF V21348=9 THEN V21348=.;
IF V21349=99 THEN V21349=.;
IF V21350=9 THEN V21350=.;
IF V21351=9 THEN V21351=.;
IF V21352=99 THEN V21352=.;
IF V21353=9 THEN V21353=.;
IF V21354=9 THEN V21354=.;
IF V21355=9 THEN V21355=.;
IF V21356=9 THEN V21356=.;
IF V21357=9 THEN V21357=.;
IF V21358=9 THEN V21358=.;
IF V21359=99 THEN V21359=.;
IF V21360=99 THEN V21360=.;
IF V21361=99 THEN V21361=.;
IF V21362=99 THEN V21362=.;
IF V21363=99 THEN V21363=.;
IF V21364=99 THEN V21364=.;
IF V21365=9 THEN V21365=.;
IF V21366=99 THEN V21366=.;
IF V21367=9 THEN V21367=.;
IF V21368=9 THEN V21368=.;
IF V21369=99 THEN V21369=.;
IF V21370=99 THEN V21370=.;
IF V21371=9 THEN V21371=.;
IF V21372=9 THEN V21372=.;
IF V21373=9 THEN V21373=.;
IF V21374=99 THEN V21374=.;
IF V21375=99 THEN V21375=.;
IF V21376=99 THEN V21376=.;
IF V21377=9 THEN V21377=.;
IF V21378=99 THEN V21378=.;
IF V21379=99 THEN V21379=.;
IF V21380=99 THEN V21380=.;
IF V21381=9 THEN V21381=.;
IF V21382=99 THEN V21382=.;
IF V21383=99 THEN V21383=.;
IF V21384=99 THEN V21384=.;
IF V21385=99 THEN V21385=.;
IF V21386=99 THEN V21386=.;
IF V21387=99 THEN V21387=.;
IF V21389=99 THEN V21389=.;
IF V21390=999 THEN V21390=.;
IF V21391=99 THEN V21391=.;
IF V21392=999 THEN V21392=.;
IF V21393=9 THEN V21393=.;
IF V21394=9 THEN V21394=.;
IF V21395=9 THEN V21395=.;
IF V21396=9 THEN V21396=.;
IF V21397=99 THEN V21397=.;
IF V21398=999 THEN V21398=.;
IF V21399=9 THEN V21399=.;
IF V21400=9 THEN V21400=.;
IF V21401=9 THEN V21401=.;
IF V21402=9 THEN V21402=.;
IF V21403=9 THEN V21403=.;
IF V21404=9 THEN V21404=.;
IF V21405=9 THEN V21405=.;
IF V21406=9 THEN V21406=.;
IF V21407=99 THEN V21407=.;
IF V21408=9 THEN V21408=.;
IF V21409=9 THEN V21409=.;
IF V21410=99 THEN V21410=.;
IF V21411=9 THEN V21411=.;
IF V21412=9 THEN V21412=.;
IF V21413=99 THEN V21413=.;
IF V21414=9 THEN V21414=.;
IF V21415=9 THEN V21415=.;
IF V21416=99 THEN V21416=.;
IF V21417=9 THEN V21417=.;
IF V21418=9 THEN V21418=.;
IF V21419=9 THEN V21419=.;
IF V21420=9 THEN V21420=.;
IF V21421=9 THEN V21421=.;
IF V21422=9 THEN V21422=.;
IF V21423=9 THEN V21423=.;
IF V21424=99 THEN V21424=.;
IF V21425=99 THEN V21425=.;
IF V21426=99 THEN V21426=.;
IF V21427=99 THEN V21427=.;
IF V21428=99 THEN V21428=.;
IF V21429=99 THEN V21429=.;
IF V21430=99 THEN V21430=.;
IF V21431=99 THEN V21431=.;
IF V21432=99 THEN V21432=.;
IF V21433=99 THEN V21433=.;
IF V21434=9 THEN V21434=.;
IF V21435=99 THEN V21435=.;
IF V21436=99 THEN V21436=.;
IF V21437=9 THEN V21437=.;
IF V21438=9 THEN V21438=.;
IF V21439=99 THEN V21439=.;
IF V21440=99 THEN V21440=.;
IF V21441=99 THEN V21441=.;
IF V21442=9 THEN V21442=.;
IF V21443=9 THEN V21443=.;
IF V21444=9 THEN V21444=.;
IF V21445=99 THEN V21445=.;
IF V21446=99 THEN V21446=.;
IF V21447=99 THEN V21447=.;
IF V21448=99 THEN V21448=.;
IF V21449=9 THEN V21449=.;
IF V21450=99 THEN V21450=.;
IF V21451=99 THEN V21451=.;
IF V21452=99 THEN V21452=.;
IF V21453=99 THEN V21453=.;
IF V21454=9 THEN V21454=.;
IF V21455=99 THEN V21455=.;
IF V21456=99 THEN V21456=.;
IF V21457=99 THEN V21457=.;
IF V21458=99 THEN V21458=.;
IF V21459=99 THEN V21459=.;
IF V21460=99 THEN V21460=.;
IF V21461=99 THEN V21461=.;
IF V21462=9 THEN V21462=.;
IF V21463=99 THEN V21463=.;
IF V21464=9 THEN V21464=.;
IF V21465=9 THEN V21465=.;
IF V21466=9 THEN V21466=.;
IF V21495=9 THEN V21495=.;
IF V21496=99 THEN V21496=.;
IF V21497=999 THEN V21497=.;
IF V21498=99 THEN V21498=.;
IF V21499=9 THEN V21499=.;
IF V21500=9 THEN V21500=.;
IF V21504=99 THEN V21504=.;
IF V21505=99 THEN V21505=.;
IF V21521=99 THEN V21521=.;
IF V21525=99 THEN V21525=.;
IF V21543=9 THEN V21543=.;
IF V21544=9 THEN V21544=.;
IF V21545=9 THEN V21545=.;
IF V21546=9 THEN V21546=.;
 
file rawdat lrecl=2347;
put    
v20302
v20310
v20324
v20325
v20326
v20333
v20334
v20344
v20345
v20347
v20374
v20375
v20377
v20405
v20406
v20407
v20408
v20409
v20410
v20411
v20412
v20436
v20444
v20446
v20449
v20451
v20501
v20600
v20601
v20603
v20617
v20648
v20650
v20651
v20652
v20653
v20672
v20673
v20674
v20675
v20687
v20688
v20689
v20693
v20696
v20720
v20796
v20797
v20856
v20867
v20943
v20944
v20995
v20997
v20998
v21022
v21081
v21098
v21099
v21158
v21169
v21245
v21246
v21309
v21313
v21322
v21358
v21365
v21368
v21388
v21420
v21423
v21434
v21438
v21481
v21484
v21488
v21495
v21504
v21505
v21522
v21547
v30734
;

 proc means;
 run; 
